/*
 * Decompiled with CFR 0.152.
 */
package com.zdawn.jwt.spi.impl;

import com.zdawn.jwt.spi.Token;
import com.zdawn.jwt.spi.TokenStore;
import com.zdawn.jwt.spi.WebToken;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTokenStore
implements TokenStore {
    private static Logger logger = LoggerFactory.getLogger(JdbcTokenStore.class);
    private DataSource dataSource;
    private String tableName = "sys_token";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void creatTokenTable() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "select * from " + this.tableName + " where 1<0";
            con = this.dataSource.getConnection();
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
        }
        catch (SQLException e) {
            try {
                JdbcTokenStore.closeResultSet(rs);
                JdbcTokenStore.closeStatement(ps);
                String sql = "create table " + this.tableName + "(token_id varchar(64) primary key,user_id varchar(32),token_state decimal(1),create_time decimal(15),last_use_time decimal(15),token_type decimal(1),use_number decimal(3))";
                try {
                    ps = con.prepareStatement(sql);
                    ps.executeUpdate();
                }
                catch (SQLException e1) {
                    logger.error("\u8868\u521b\u5efa\u5931\u8d25", (Throwable)e1);
                }
            }
            catch (Throwable throwable) {
                JdbcTokenStore.closeResultSet(rs);
                JdbcTokenStore.closeStatement(ps);
                JdbcTokenStore.closeConnection(con);
                throw throwable;
            }
            JdbcTokenStore.closeResultSet(rs);
            JdbcTokenStore.closeStatement(ps);
            JdbcTokenStore.closeConnection(con);
        }
        JdbcTokenStore.closeResultSet(rs);
        JdbcTokenStore.closeStatement(ps);
        JdbcTokenStore.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void creatTokenHisTable() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "select * from " + this.tableName + "_his where 1<0";
            con = this.dataSource.getConnection();
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
        }
        catch (SQLException e) {
            try {
                JdbcTokenStore.closeResultSet(rs);
                JdbcTokenStore.closeStatement(ps);
                String sql = "create table " + this.tableName + "_his(token_id varchar(64) primary key,user_id varchar(32),token_state decimal(1),create_time decimal(15),last_use_time decimal(15),token_type decimal(1),use_number decimal(3))";
                try {
                    ps = con.prepareStatement(sql);
                    ps.executeUpdate();
                }
                catch (SQLException e1) {
                    logger.error("\u5386\u53f2\u8868\u521b\u5efa\u5931\u8d25", (Throwable)e1);
                }
            }
            catch (Throwable throwable) {
                JdbcTokenStore.closeResultSet(rs);
                JdbcTokenStore.closeStatement(ps);
                JdbcTokenStore.closeConnection(con);
                throw throwable;
            }
            JdbcTokenStore.closeResultSet(rs);
            JdbcTokenStore.closeStatement(ps);
            JdbcTokenStore.closeConnection(con);
        }
        JdbcTokenStore.closeResultSet(rs);
        JdbcTokenStore.closeStatement(ps);
        JdbcTokenStore.closeConnection(con);
    }

    @Override
    public void saveToken(Token token) throws SQLException {
        Connection con = null;
        PreparedStatement ps = null;
        String sql = "insert into " + this.tableName + "(token_id,user_id,token_state,create_time,last_use_time,token_type,use_number) values(?,?,?,?,?,?,?)";
        try {
            con = this.dataSource.getConnection();
            ps = con.prepareStatement(sql);
            JdbcTokenStore.set(ps, 1, token.getTokenId(), 12);
            JdbcTokenStore.set(ps, 2, token.getUserId(), 12);
            JdbcTokenStore.set(ps, 3, token.getTokenState(), 4);
            JdbcTokenStore.set(ps, 4, token.getCreateTime(), -5);
            JdbcTokenStore.set(ps, 5, token.getLastUseTime(), -5);
            JdbcTokenStore.set(ps, 6, token.getTokenType(), 4);
            JdbcTokenStore.set(ps, 7, token.getUseNumber(), 4);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JdbcTokenStore.closeStatement(ps);
                JdbcTokenStore.closeConnection(con);
                throw throwable;
            }
        }
        JdbcTokenStore.closeStatement(ps);
        JdbcTokenStore.closeConnection(con);
    }

    @Override
    public Token queryTokenById(String tokenId) throws SQLException {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Token token = null;
        try {
            String sql = "select token_id,user_id,token_state,create_time,last_use_time,token_type,use_number from " + this.tableName + " where token_id=?";
            con = this.dataSource.getConnection();
            ps = con.prepareStatement(sql);
            JdbcTokenStore.set(ps, 1, tokenId, 12);
            rs = ps.executeQuery();
            while (rs.next()) {
                token = new Token();
                token.setTokenId(rs.getString("token_id"));
                token.setUserId(rs.getString("user_id"));
                token.setTokenState(rs.getInt("token_state"));
                token.setCreateTime(rs.getLong("create_time"));
                token.setLastUseTime(rs.getLong("last_use_time"));
                token.setTokenType(rs.getInt("token_type"));
                token.setUseNumber(rs.getInt("use_number"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error("\u67e5\u8be2" + this.tableName + "\u8868\u5931\u8d25", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                JdbcTokenStore.closeResultSet(rs);
                JdbcTokenStore.closeStatement(ps);
                JdbcTokenStore.closeConnection(con);
                throw throwable;
            }
        }
        JdbcTokenStore.closeResultSet(rs);
        JdbcTokenStore.closeStatement(ps);
        JdbcTokenStore.closeConnection(con);
        return token;
    }

    @Override
    public List<Token> queryTokenByUserId(String userId) throws SQLException {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<Token> tokenList = new ArrayList<Token>();
        try {
            String sql = "select token_id,user_id,token_state,create_time,last_use_time,token_type,use_number from " + this.tableName + " where user_id=?";
            con = this.dataSource.getConnection();
            ps = con.prepareStatement(sql);
            JdbcTokenStore.set(ps, 1, userId, 12);
            rs = ps.executeQuery();
            while (rs.next()) {
                Token token = new Token();
                token.setTokenId(rs.getString("token_id"));
                token.setUserId(rs.getString("user_id"));
                token.setTokenState(rs.getInt("token_state"));
                token.setCreateTime(rs.getLong("create_time"));
                token.setLastUseTime(rs.getLong("last_use_time"));
                token.setTokenType(rs.getInt("token_type"));
                token.setUseNumber(rs.getInt("use_number"));
                tokenList.add(token);
            }
        }
        catch (SQLException e) {
            try {
                logger.error("\u67e5\u8be2" + this.tableName + "\u8868\u5931\u8d25", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                JdbcTokenStore.closeResultSet(rs);
                JdbcTokenStore.closeStatement(ps);
                JdbcTokenStore.closeConnection(con);
                throw throwable;
            }
        }
        JdbcTokenStore.closeResultSet(rs);
        JdbcTokenStore.closeStatement(ps);
        JdbcTokenStore.closeConnection(con);
        return tokenList;
    }

    @Override
    public void updateToken(Token token) throws SQLException {
        Connection con = null;
        PreparedStatement ps = null;
        String sql = "update " + this.tableName + " set token_state=?,last_use_time=?,token_type =?,use_number=? where token_id=?";
        try {
            con = this.dataSource.getConnection();
            ps = con.prepareStatement(sql);
            JdbcTokenStore.set(ps, 1, token.getTokenState(), 4);
            JdbcTokenStore.set(ps, 2, token.getLastUseTime(), -5);
            JdbcTokenStore.set(ps, 3, token.getTokenType(), 4);
            JdbcTokenStore.set(ps, 4, token.getUseNumber(), 4);
            JdbcTokenStore.set(ps, 5, token.getTokenId(), 12);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JdbcTokenStore.closeStatement(ps);
                JdbcTokenStore.closeConnection(con);
                throw throwable;
            }
        }
        JdbcTokenStore.closeStatement(ps);
        JdbcTokenStore.closeConnection(con);
    }

    @Override
    public void delTokenById(String tokenId) throws SQLException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            String sql = "delete from " + this.tableName + " where token_id = ?";
            con = this.dataSource.getConnection();
            ps = con.prepareStatement(sql);
            JdbcTokenStore.set(ps, 1, tokenId, 12);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JdbcTokenStore.closeStatement(ps);
                JdbcTokenStore.closeConnection(con);
                throw throwable;
            }
        }
        JdbcTokenStore.closeStatement(ps);
        JdbcTokenStore.closeConnection(con);
    }

    @Override
    public void clearTokenByOverTime(int expireTime) throws SQLException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            long time = new Date().getTime() - (long)(expireTime * 60 * 1000);
            String sql = "delete from " + this.tableName + " where last_use_time <= ?";
            con = this.dataSource.getConnection();
            ps = con.prepareStatement(sql);
            JdbcTokenStore.set(ps, 1, time, -5);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JdbcTokenStore.closeStatement(ps);
                JdbcTokenStore.closeConnection(con);
                throw throwable;
            }
        }
        JdbcTokenStore.closeStatement(ps);
        JdbcTokenStore.closeConnection(con);
    }

    @Override
    public void moveHistoryTokenByOverTime(int expireTime) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        long time = new Date().getTime() - (long)(expireTime * 60 * 1000);
        String sql = "insert into " + this.tableName + "_his(token_id,user_id,token_state,create_time,last_use_time,token_type,use_number) select token_id,user_id,token_state,create_time,last_use_time,token_type,use_number from " + this.tableName + " where last_use_time <= ?";
        try {
            con = this.dataSource.getConnection();
            ps = con.prepareStatement(sql);
            JdbcTokenStore.set(ps, 1, time, -5);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JdbcTokenStore.closeStatement(ps);
                throw throwable;
            }
        }
        JdbcTokenStore.closeStatement(ps);
        try {
            ps = con.prepareStatement("delete from " + this.tableName + " where last_use_time <= ?");
            JdbcTokenStore.set(ps, 1, time, -5);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            JdbcTokenStore.closeStatement(ps);
            JdbcTokenStore.closeConnection(con);
        }
    }

    @Override
    public void moveHistoryToken(String tokenId) throws SQLException {
        Connection con = null;
        PreparedStatement ps = null;
        String sql = "insert into " + this.tableName + "_his(token_id,user_id,token_state,create_time,last_use_time,token_type,use_number) select token_id,user_id,token_state,create_time,last_use_time,token_type,use_number from " + this.tableName + " where token_id=?";
        try {
            con = this.dataSource.getConnection();
            ps = con.prepareStatement(sql);
            JdbcTokenStore.set(ps, 1, tokenId, 12);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                JdbcTokenStore.closeStatement(ps);
                throw throwable;
            }
        }
        JdbcTokenStore.closeStatement(ps);
        try {
            ps = con.prepareStatement("delete from " + this.tableName + " where token_id = ?");
            JdbcTokenStore.set(ps, 1, tokenId, 12);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            JdbcTokenStore.closeStatement(ps);
            JdbcTokenStore.closeConnection(con);
        }
    }

    @Override
    public void validateTokenConfig(WebToken webToken) {
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    protected static void closeStatement(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            logger.error("closeStatement", (Throwable)e);
        }
    }

    protected static void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            logger.error("closeSResultSet", (Throwable)e);
        }
    }

    protected static void closeConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception e) {
            logger.error("closeConnection", (Throwable)e);
        }
    }

    protected static void set(PreparedStatement ps, int index, Object value, int sqlType) throws SQLException {
        if (value != null) {
            ps.setObject(index, value, sqlType);
        } else {
            ps.setNull(index, sqlType);
        }
    }
}

