/*
 * Decompiled with CFR 0.152.
 */
package com.zdawn.jwt.spi.impl;

import com.zdawn.jwt.spi.Token;
import com.zdawn.jwt.spi.TokenStore;
import com.zdawn.jwt.spi.WebToken;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.security.KeyFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebTokenImpl
implements WebToken {
    private static Logger log = LoggerFactory.getLogger(WebTokenImpl.class);
    private int expireTime = 30;
    private boolean tokenHistory = false;
    private int meteringCount = 1;
    private int uidTokenCount = 1;
    private Key privateKey;
    private Key publicKey;
    private TokenStore tokenStore;
    private List<String> securityKeyList;
    private Map<String, Object> header;
    private String verifierKey;

    private Map<String, Object> getHeader() {
        if (this.header == null) {
            this.header = new HashMap<String, Object>();
            this.header.put("alg", "RS256");
            this.header.put("typ", "JWT");
        }
        return this.header;
    }

    private Token createToken(String uid, String type) {
        Token token = new Token();
        token.setTokenId(UUID.randomUUID().toString());
        token.setUserId(uid);
        long currentTime = System.currentTimeMillis();
        token.setCreateTime(currentTime);
        token.setLastUseTime(currentTime);
        token.setTokenState(0);
        int tokenType = 2;
        if ("metering".equals(type)) {
            tokenType = 1;
        }
        token.setTokenType(tokenType);
        token.setUseNumber(1);
        return token;
    }

    private Token getEarliestToken(List<Token> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        long lastTime = System.currentTimeMillis() + 1000L;
        Token temp = null;
        for (Token token : list) {
            if (token.getTokenState() == 1) {
                return token;
            }
            if (token.getLastUseTime() >= lastTime) continue;
            lastTime = token.getLastUseTime();
            temp = token;
        }
        return temp;
    }

    @Override
    public String getJwtToken(String uid, String type) throws Exception {
        String jwt = null;
        List<Token> list = this.tokenStore.queryTokenByUserId(uid);
        if (list != null && this.uidTokenCount <= list.size()) {
            Token earlyToken = this.getEarliestToken(list);
            if (this.tokenHistory) {
                this.tokenStore.moveHistoryToken(earlyToken.getTokenId());
            } else {
                this.tokenStore.delTokenById(earlyToken.getTokenId());
            }
        }
        Token token = this.createToken(uid, type);
        this.tokenStore.saveToken(token);
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put("iss", "sinosoft");
        claims.put("sub", type);
        claims.put("jti", token.getTokenId());
        jwt = Jwts.builder().setHeader(this.getHeader()).setClaims(claims).signWith(this.privateKey, SignatureAlgorithm.RS256).compact();
        return jwt;
    }

    @Override
    public String verifyJwtToken(String jwtToken) throws Exception {
        String uid = null;
        Jws claims = Jwts.parser().setSigningKey(this.publicKey).parseClaimsJws(jwtToken);
        String tokenId = ((Claims)claims.getBody()).getId();
        Token token = this.tokenStore.queryTokenById(tokenId);
        if (token == null) {
            throw new Exception("token not exist");
        }
        uid = token.getUserId();
        if (token.getTokenState() == 1) {
            throw new Exception("token expire");
        }
        long currentTime = System.currentTimeMillis();
        boolean expire = false;
        if (1 == token.getTokenType()) {
            if (currentTime - token.getLastUseTime() > (long)(this.expireTime * 60000)) {
                token.setTokenState(1);
                expire = true;
            }
            if (!expire && this.meteringCount <= token.getUseNumber()) {
                expire = true;
            }
        } else if (currentTime - token.getLastUseTime() > (long)(this.expireTime * 60000)) {
            token.setTokenState(1);
            expire = true;
        }
        if (expire) {
            if (this.tokenHistory) {
                this.tokenStore.updateToken(token);
                this.tokenStore.moveHistoryToken(token.getTokenId());
            } else {
                this.tokenStore.delTokenById(token.getTokenId());
            }
            throw new Exception("token expire");
        }
        token.setLastUseTime(currentTime);
        if (1 == token.getTokenType()) {
            token.setUseNumber(token.getUseNumber() + 1);
        }
        this.tokenStore.updateToken(token);
        return uid;
    }

    @Override
    public void clearExpireToken() {
        try {
            if (this.tokenHistory) {
                this.tokenStore.moveHistoryTokenByOverTime(this.expireTime);
            } else {
                this.tokenStore.clearTokenByOverTime(this.expireTime);
            }
        }
        catch (Exception e) {
            log.error("clearExpireToken==>", (Throwable)e);
        }
    }

    @Override
    public Map<String, String> getTokenConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        if (this.verifierKey == null) {
            this.verifierKey = Base64.getMimeEncoder().encodeToString(this.publicKey.getEncoded());
        }
        config.put("alg", "RS256");
        config.put("pubKey", this.verifierKey);
        config.put("expireTime", this.expireTime + "");
        config.put("meteringCount", this.meteringCount + "");
        config.put("tokenHistory", this.tokenHistory + "");
        return config;
    }

    @Override
    public void setTokenConfig(Map<String, String> config) {
        try {
            KeyFactory keyFactory;
            String temp = config.get("expireTime");
            if (temp != null && !"".equals(temp)) {
                this.expireTime = Integer.parseInt(temp);
                log.info("set expireTime " + temp);
            }
            if ((temp = config.get("meteringCount")) != null && !"".equals(temp)) {
                this.meteringCount = Integer.parseInt(temp);
                log.info("set meteringCount " + temp);
            }
            if ((temp = config.get("tokenHistory")) != null && !"".equals(temp)) {
                this.tokenHistory = Boolean.parseBoolean(temp);
                log.info("set tokenHistory " + temp);
            }
            if ((temp = config.get("pubKey")) != null && !"".equals(temp)) {
                X509EncodedKeySpec pubX509 = new X509EncodedKeySpec(Base64.getMimeDecoder().decode(temp.getBytes()));
                keyFactory = KeyFactory.getInstance("RSA");
                this.publicKey = keyFactory.generatePublic(pubX509);
            }
            if ((temp = config.get("priKey")) != null && !"".equals(temp)) {
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getMimeDecoder().decode(temp.getBytes()));
                keyFactory = KeyFactory.getInstance("RSA");
                this.privateKey = keyFactory.generatePrivate(keySpec);
            }
        }
        catch (Exception e) {
            log.error("setTokenConfig", (Throwable)e);
        }
    }

    @Override
    public boolean validateSecurityKeyForPublicKey(String securityKey) {
        if (this.securityKeyList == null) {
            return false;
        }
        return this.securityKeyList.contains(securityKey);
    }

    @Override
    public void validateTokenConfig() {
        if (this.uidTokenCount > 10) {
            log.warn("\u76f8\u540c\u8eab\u4efd\u6807\u8bc6\u51c6\u8bb8\u5206\u53d1token\u4e2a\u6570\u4e0d\u63a8\u8350\u5927\u4e8e10");
        }
        if (this.meteringCount > 3) {
            log.warn("\u8ba1\u6b21\u65b9\u5f0f\u4f7f\u7528\u6b21\u6570\u4e0d\u63a8\u8350\u5927\u4e8e3");
        }
        this.tokenStore.validateTokenConfig(this);
    }

    @Override
    public void delJwtToken(String jwtToken) throws Exception {
        Jws claims = Jwts.parser().setSigningKey(this.publicKey).parseClaimsJws(jwtToken);
        String tokenId = ((Claims)claims.getBody()).getId();
        if (tokenId != null) {
            this.tokenStore.delTokenById(tokenId);
        }
    }

    @Override
    public void delJwtTokenByUid(String uid) throws Exception {
        List<Token> list = this.tokenStore.queryTokenByUserId(uid);
        if (list == null) {
            return;
        }
        for (Token token : list) {
            this.tokenStore.delTokenById(token.getTokenId());
        }
    }

    public void setExpireTime(int expireTime) {
        this.expireTime = expireTime;
    }

    public void setTokenHistory(boolean tokenHistory) {
        this.tokenHistory = tokenHistory;
    }

    public void setMeteringCount(int meteringCount) {
        this.meteringCount = meteringCount;
    }

    public void setUidTokenCount(int uidTokenCount) {
        this.uidTokenCount = uidTokenCount;
    }

    public void setPrivateKey(Key privateKey) {
        this.privateKey = privateKey;
    }

    public void setPublicKey(Key publicKey) {
        this.publicKey = publicKey;
    }

    public void setTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    public void setSecurityKeyList(List<String> securityKeyList) {
        this.securityKeyList = securityKeyList;
    }
}

