/*
 * Decompiled with CFR 0.152.
 */
package com.zdawn.jwt.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zdawn.jwt.spi.TokenStore;
import com.zdawn.jwt.spi.WebToken;
import com.zdawn.jwt.spi.impl.WebTokenImpl;
import com.zdawn.jwt.web.IgnoreUidDecoder;
import com.zdawn.jwt.web.UidDecoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenVerifierFilter
implements Filter {
    private static Logger log = LoggerFactory.getLogger(TokenVerifierFilter.class);
    private List<String> exceptUrlList;
    private String verifyTokenConfigUrl;
    private WebToken webToken;
    private String securityKey;
    private String jwtHttpHeaderKey = "Authorization";
    private boolean pullTokenConfig = false;
    private boolean checkUid = false;
    private UidDecoder decoder = new IgnoreUidDecoder();
    private String uidHttpHeaderKey = "uid";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.pullTokenConfig) {
            this.pullTokenConfig();
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        try {
            if (this.exceptURL(req.getRequestURI(), req.getContextPath(), this.exceptUrlList)) {
                chain.doFilter(request, response);
            } else {
                try {
                    String token = req.getHeader(this.jwtHttpHeaderKey);
                    if (token == null || "".equals(token)) {
                        token = this.parseValue(req.getQueryString(), this.jwtHttpHeaderKey);
                    }
                    if (token == null || "".equals(token)) {
                        throw new Exception("jwt token\u4e3a\u7a7a");
                    }
                    String uid = this.webToken.verifyJwtToken(token);
                    if (this.checkUid) {
                        String passUid;
                        String inputUid = req.getHeader(this.uidHttpHeaderKey);
                        if (inputUid == null || "".equals(inputUid)) {
                            inputUid = this.parseValue(req.getQueryString(), this.uidHttpHeaderKey);
                        }
                        if ((passUid = this.decoder.decodeUid(inputUid)) == null || !uid.equals(passUid)) {
                            throw new Exception("check uid failure");
                        }
                    }
                    chain.doFilter(request, response);
                }
                catch (Exception e) {
                    res.setContentType("application/json;charset=utf-8");
                    res.addHeader("sessionstatus", "timeout");
                    ServletOutputStream outputStream = res.getOutputStream();
                    String data = this.getResultInfo(false, e.getMessage());
                    byte[] dataByteArr = data.getBytes("UTF-8");
                    outputStream.write(dataByteArr);
                    outputStream.flush();
                    outputStream.close();
                }
            }
        }
        catch (Exception e) {
            log.error("doFilter", (Throwable)e);
        }
    }

    public void destroy() {
    }

    public void setExceptUrlList(List<String> exceptUrlList) {
        this.exceptUrlList = exceptUrlList;
    }

    public void addExceptUrl(String ... url) {
        if (this.exceptUrlList == null) {
            this.exceptUrlList = new ArrayList<String>();
        }
        for (String one : url) {
            this.exceptUrlList.add(one);
        }
    }

    public void setVerifyTokenConfigUrl(String verifyTokenConfigUrl) {
        this.verifyTokenConfigUrl = verifyTokenConfigUrl;
    }

    public void setTokenStore(TokenStore tokenStore) {
        if (this.webToken == null) {
            this.webToken = new WebTokenImpl();
        }
        if (this.webToken instanceof WebTokenImpl) {
            WebTokenImpl impl = (WebTokenImpl)this.webToken;
            impl.setTokenStore(tokenStore);
        }
    }

    public void setWebToken(WebToken webToken) {
        this.webToken = webToken;
    }

    public void setSecurityKey(String securityKey) {
        this.securityKey = securityKey;
    }

    private boolean exceptURL(String currentURL, String contextPath, List<String> exceptList) {
        if (exceptList == null || exceptList.size() == 0) {
            return false;
        }
        currentURL = currentURL.substring(contextPath.length(), currentURL.length());
        for (String temp : exceptList) {
            String sub;
            int index = temp.indexOf("*");
            if (!(index > 0 ? currentURL.startsWith(sub = temp.substring(0, index)) && currentURL.length() > sub.length() : currentURL.equals(temp))) continue;
            return true;
        }
        return false;
    }

    private String getResultInfo(boolean result, String message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("result", result);
        map.put("desc", message);
        String json = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            json = mapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return json;
    }

    private synchronized void pullTokenConfig() {
        if (this.pullTokenConfig) {
            return;
        }
        if (this.verifyTokenConfigUrl == null) {
            this.pullTokenConfig = true;
            return;
        }
        try {
            String jsonString = this.getVerifyTokenConfig(this.verifyTokenConfigUrl, 10000, 10000);
            Map<String, String> config = this.parseTokenConfig(jsonString);
            this.webToken.setTokenConfig(config);
            this.webToken.validateTokenConfig();
            this.pullTokenConfig = true;
        }
        catch (Exception e) {
            log.error(this.verifyTokenConfigUrl);
            log.error("pullTokenConfig", (Throwable)e);
        }
    }

    private String getVerifyTokenConfig(String serviceUrl, int connectTimeout, int readTimeout) throws Exception {
        String result;
        block9: {
            HttpURLConnection connection = null;
            String charset = "UTF-8";
            result = null;
            try {
                byte[] data = "get token config".getBytes();
                URL url = new URL(serviceUrl);
                URLConnection temp = url.openConnection();
                connection = (HttpURLConnection)temp;
                connection.setConnectTimeout(connectTimeout);
                connection.setReadTimeout(readTimeout);
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=" + charset);
                connection.setRequestProperty("Accept-Charset", charset);
                connection.setRequestProperty("Content-Length", data.length + "");
                connection.setRequestProperty("Accept", "text/html,application/json,application/xml");
                connection.setRequestProperty("security-key", this.securityKey);
                connection.setUseCaches(false);
                connection.setDoInput(true);
                connection.setDoOutput(true);
                OutputStream os = connection.getOutputStream();
                os.write(data);
                os.flush();
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    InputStream is = connection.getInputStream();
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is, charset));
                    String line = null;
                    StringBuilder sb = new StringBuilder();
                    while ((line = rd.readLine()) != null) {
                        sb.append(line);
                    }
                    rd.close();
                    result = sb.toString();
                    break block9;
                }
                InputStream is = connection.getErrorStream();
                BufferedReader rd = new BufferedReader(new InputStreamReader(is, charset));
                String line = null;
                StringBuilder sb = new StringBuilder();
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
                rd.close();
                throw new Exception(sb.toString());
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        return result;
    }

    private Map<String, String> parseTokenConfig(String jsonString) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, String> data = new HashMap<String, String>();
        JsonNode rootNode = (JsonNode)mapper.readValue(jsonString, JsonNode.class);
        Iterator it = rootNode.fieldNames();
        while (it.hasNext()) {
            String name = (String)it.next();
            JsonNode one = rootNode.path(name);
            if (!one.isValueNode()) continue;
            data.put(name, one.asText());
        }
        return data;
    }

    private String parseValue(String queryString, String key) {
        String onlyKey;
        if (queryString == null || queryString.equals("")) {
            return null;
        }
        int stringStart = 0;
        String attrName = null;
        for (int i = 0; i < queryString.length(); ++i) {
            char c = queryString.charAt(i);
            if (c == '=' && attrName == null) {
                attrName = queryString.substring(stringStart, i);
                stringStart = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (attrName != null) {
                String value = queryString.substring(stringStart, i);
                if (key.equals(attrName)) {
                    return value;
                }
            } else {
                String onlyKey2 = queryString.substring(stringStart, i);
                if (key.equals(onlyKey2)) {
                    return null;
                }
            }
            stringStart = i + 1;
            attrName = null;
        }
        if (attrName != null) {
            String value = queryString.substring(stringStart, queryString.length());
            if (key.equals(attrName)) {
                return value;
            }
        } else if (queryString.length() != stringStart && key.equals(onlyKey = queryString.substring(stringStart, queryString.length()))) {
            return null;
        }
        return null;
    }

    public void setJwtHttpHeaderKey(String jwtHttpHeaderKey) {
        this.jwtHttpHeaderKey = jwtHttpHeaderKey;
    }

    public void setCheckUid(boolean checkUid) {
        this.checkUid = checkUid;
    }

    public void setUidHttpHeaderKey(String uidHttpHeaderKey) {
        this.uidHttpHeaderKey = uidHttpHeaderKey;
    }

    public void setDecoder(UidDecoder decoder) {
        this.decoder = decoder;
    }
}

