/*
 * Decompiled with CFR 0.152.
 */
package com.zdawn.jwt.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zdawn.jwt.spi.WebToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebTokenConfigServlet
extends HttpServlet {
    private static final long serialVersionUID = 2482303976275355486L;
    private static Logger log = LoggerFactory.getLogger(WebTokenConfigServlet.class);
    private WebToken webToken;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String json = "{}";
        req.setCharacterEncoding("UTF-8");
        String key = req.getHeader("security-key");
        Map<Object, Object> result = null;
        if (key == null) {
            result = new HashMap<String, String>();
            result.put("result", "false");
            result.put("desc", "require security-key in header");
        } else if (this.webToken.validateSecurityKeyForPublicKey(key)) {
            result = this.webToken.getTokenConfig();
            result.put("result", "true");
        } else {
            result = new HashMap();
            result.put("result", "false");
            result.put("desc", "security-key not pass");
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            json = mapper.writeValueAsString(result);
        }
        catch (JsonProcessingException e) {
            log.error("getTokenKey==>", (Throwable)e);
        }
        resp.setContentType("text/json; charset=utf-8");
        resp.setHeader("Cache-Control", "no-cache");
        ServletOutputStream outputStream = resp.getOutputStream();
        byte[] dataByteArr = json.getBytes("UTF-8");
        outputStream.write(dataByteArr);
        outputStream.flush();
    }

    public void setWebToken(WebToken webToken) {
        this.webToken = webToken;
    }
}

