/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.config;

public class ReportingConfiguration {
    private Boolean reportingEnabled;
    private String projectKey;
    private ServerConfiguration server;
    private RunConfiguration run;
    private MilestoneConfiguration milestone;
    private NotificationConfiguration notification;

    public boolean isReportingEnabled() {
        return this.reportingEnabled != null && this.reportingEnabled != false;
    }

    ReportingConfiguration(Boolean reportingEnabled, String projectKey, ServerConfiguration server, RunConfiguration run, MilestoneConfiguration milestone, NotificationConfiguration notification) {
        this.reportingEnabled = reportingEnabled;
        this.projectKey = projectKey;
        this.server = server;
        this.run = run;
        this.milestone = milestone;
        this.notification = notification;
    }

    public static ReportingConfigurationBuilder builder() {
        return new ReportingConfigurationBuilder();
    }

    public Boolean getReportingEnabled() {
        return this.reportingEnabled;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public ServerConfiguration getServer() {
        return this.server;
    }

    public RunConfiguration getRun() {
        return this.run;
    }

    public MilestoneConfiguration getMilestone() {
        return this.milestone;
    }

    public NotificationConfiguration getNotification() {
        return this.notification;
    }

    public void setReportingEnabled(Boolean reportingEnabled) {
        this.reportingEnabled = reportingEnabled;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public void setServer(ServerConfiguration server) {
        this.server = server;
    }

    public void setRun(RunConfiguration run) {
        this.run = run;
    }

    public void setMilestone(MilestoneConfiguration milestone) {
        this.milestone = milestone;
    }

    public void setNotification(NotificationConfiguration notification) {
        this.notification = notification;
    }

    public static class ReportingConfigurationBuilder {
        private Boolean reportingEnabled;
        private String projectKey;
        private ServerConfiguration server;
        private RunConfiguration run;
        private MilestoneConfiguration milestone;
        private NotificationConfiguration notification;

        ReportingConfigurationBuilder() {
        }

        public ReportingConfigurationBuilder reportingEnabled(Boolean reportingEnabled) {
            this.reportingEnabled = reportingEnabled;
            return this;
        }

        public ReportingConfigurationBuilder projectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public ReportingConfigurationBuilder server(ServerConfiguration server) {
            this.server = server;
            return this;
        }

        public ReportingConfigurationBuilder run(RunConfiguration run) {
            this.run = run;
            return this;
        }

        public ReportingConfigurationBuilder milestone(MilestoneConfiguration milestone) {
            this.milestone = milestone;
            return this;
        }

        public ReportingConfigurationBuilder notification(NotificationConfiguration notification) {
            this.notification = notification;
            return this;
        }

        public ReportingConfiguration build() {
            return new ReportingConfiguration(this.reportingEnabled, this.projectKey, this.server, this.run, this.milestone, this.notification);
        }

        public String toString() {
            return "ReportingConfiguration.ReportingConfigurationBuilder(reportingEnabled=" + this.reportingEnabled + ", projectKey=" + this.projectKey + ", server=" + this.server + ", run=" + this.run + ", milestone=" + this.milestone + ", notification=" + this.notification + ")";
        }
    }

    public static class NotificationConfiguration {
        private Boolean notifyOnEachFailure;
        private String slackChannels;
        private String msTeamsChannels;
        private String emails;

        public Boolean getNotifyOnEachFailure() {
            return this.notifyOnEachFailure;
        }

        public String getSlackChannels() {
            return this.slackChannels;
        }

        public String getMsTeamsChannels() {
            return this.msTeamsChannels;
        }

        public String getEmails() {
            return this.emails;
        }

        public void setNotifyOnEachFailure(Boolean notifyOnEachFailure) {
            this.notifyOnEachFailure = notifyOnEachFailure;
        }

        public void setSlackChannels(String slackChannels) {
            this.slackChannels = slackChannels;
        }

        public void setMsTeamsChannels(String msTeamsChannels) {
            this.msTeamsChannels = msTeamsChannels;
        }

        public void setEmails(String emails) {
            this.emails = emails;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NotificationConfiguration)) {
                return false;
            }
            NotificationConfiguration other = (NotificationConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$notifyOnEachFailure = this.getNotifyOnEachFailure();
            Boolean other$notifyOnEachFailure = other.getNotifyOnEachFailure();
            if (this$notifyOnEachFailure == null ? other$notifyOnEachFailure != null : !((Object)this$notifyOnEachFailure).equals(other$notifyOnEachFailure)) {
                return false;
            }
            String this$slackChannels = this.getSlackChannels();
            String other$slackChannels = other.getSlackChannels();
            if (this$slackChannels == null ? other$slackChannels != null : !this$slackChannels.equals(other$slackChannels)) {
                return false;
            }
            String this$msTeamsChannels = this.getMsTeamsChannels();
            String other$msTeamsChannels = other.getMsTeamsChannels();
            if (this$msTeamsChannels == null ? other$msTeamsChannels != null : !this$msTeamsChannels.equals(other$msTeamsChannels)) {
                return false;
            }
            String this$emails = this.getEmails();
            String other$emails = other.getEmails();
            return !(this$emails == null ? other$emails != null : !this$emails.equals(other$emails));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NotificationConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $notifyOnEachFailure = this.getNotifyOnEachFailure();
            result = result * 59 + ($notifyOnEachFailure == null ? 43 : ((Object)$notifyOnEachFailure).hashCode());
            String $slackChannels = this.getSlackChannels();
            result = result * 59 + ($slackChannels == null ? 43 : $slackChannels.hashCode());
            String $msTeamsChannels = this.getMsTeamsChannels();
            result = result * 59 + ($msTeamsChannels == null ? 43 : $msTeamsChannels.hashCode());
            String $emails = this.getEmails();
            result = result * 59 + ($emails == null ? 43 : $emails.hashCode());
            return result;
        }

        public String toString() {
            return "ReportingConfiguration.NotificationConfiguration(notifyOnEachFailure=" + this.getNotifyOnEachFailure() + ", slackChannels=" + this.getSlackChannels() + ", msTeamsChannels=" + this.getMsTeamsChannels() + ", emails=" + this.getEmails() + ")";
        }

        public NotificationConfiguration() {
        }

        public NotificationConfiguration(Boolean notifyOnEachFailure, String slackChannels, String msTeamsChannels, String emails) {
            this.notifyOnEachFailure = notifyOnEachFailure;
            this.slackChannels = slackChannels;
            this.msTeamsChannels = msTeamsChannels;
            this.emails = emails;
        }
    }

    public static class RunConfiguration {
        private String displayName;
        private String build;
        private String environment;
        private String context;
        private Boolean retryKnownIssues;
        private Boolean substituteRemoteWebDrivers;
        private Boolean treatSkipsAsFailures;
        private TestCaseStatus testCaseStatus = new TestCaseStatus();

        public String getDisplayName() {
            return this.displayName;
        }

        public String getBuild() {
            return this.build;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getContext() {
            return this.context;
        }

        public Boolean getRetryKnownIssues() {
            return this.retryKnownIssues;
        }

        public Boolean getSubstituteRemoteWebDrivers() {
            return this.substituteRemoteWebDrivers;
        }

        public Boolean getTreatSkipsAsFailures() {
            return this.treatSkipsAsFailures;
        }

        public TestCaseStatus getTestCaseStatus() {
            return this.testCaseStatus;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public void setBuild(String build) {
            this.build = build;
        }

        public void setEnvironment(String environment) {
            this.environment = environment;
        }

        public void setContext(String context) {
            this.context = context;
        }

        public void setRetryKnownIssues(Boolean retryKnownIssues) {
            this.retryKnownIssues = retryKnownIssues;
        }

        public void setSubstituteRemoteWebDrivers(Boolean substituteRemoteWebDrivers) {
            this.substituteRemoteWebDrivers = substituteRemoteWebDrivers;
        }

        public void setTreatSkipsAsFailures(Boolean treatSkipsAsFailures) {
            this.treatSkipsAsFailures = treatSkipsAsFailures;
        }

        public void setTestCaseStatus(TestCaseStatus testCaseStatus) {
            this.testCaseStatus = testCaseStatus;
        }

        public RunConfiguration() {
        }

        public RunConfiguration(String displayName, String build, String environment, String context, Boolean retryKnownIssues, Boolean substituteRemoteWebDrivers, Boolean treatSkipsAsFailures, TestCaseStatus testCaseStatus) {
            this.displayName = displayName;
            this.build = build;
            this.environment = environment;
            this.context = context;
            this.retryKnownIssues = retryKnownIssues;
            this.substituteRemoteWebDrivers = substituteRemoteWebDrivers;
            this.treatSkipsAsFailures = treatSkipsAsFailures;
            this.testCaseStatus = testCaseStatus;
        }

        public static class TestCaseStatus {
            private String onPass;
            private String onFail;
            private String onSkip;

            public String getOnPass() {
                return this.onPass;
            }

            public String getOnFail() {
                return this.onFail;
            }

            public String getOnSkip() {
                return this.onSkip;
            }

            public void setOnPass(String onPass) {
                this.onPass = onPass;
            }

            public void setOnFail(String onFail) {
                this.onFail = onFail;
            }

            public void setOnSkip(String onSkip) {
                this.onSkip = onSkip;
            }

            public TestCaseStatus() {
            }

            public TestCaseStatus(String onPass, String onFail, String onSkip) {
                this.onPass = onPass;
                this.onFail = onFail;
                this.onSkip = onSkip;
            }
        }
    }

    public static class ServerConfiguration {
        private String hostname;
        private String accessToken;

        public String getHostname() {
            return this.hostname;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public ServerConfiguration() {
        }

        public ServerConfiguration(String hostname, String accessToken) {
            this.hostname = hostname;
            this.accessToken = accessToken;
        }
    }

    public static class MilestoneConfiguration {
        private Long id;
        private String name;

        public Long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MilestoneConfiguration)) {
                return false;
            }
            MilestoneConfiguration other = (MilestoneConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$id = this.getId();
            Long other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MilestoneConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "ReportingConfiguration.MilestoneConfiguration(id=" + this.getId() + ", name=" + this.getName() + ")";
        }

        public MilestoneConfiguration() {
        }

        public MilestoneConfiguration(Long id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}

