/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.config.provider;

import com.zebrunner.agent.core.config.ConfigurationProvider;
import com.zebrunner.agent.core.config.ConfigurationUtils;
import com.zebrunner.agent.core.config.ReportingConfiguration;
import com.zebrunner.agent.core.exception.TestAgentException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class YamlConfigurationProvider
implements ConfigurationProvider {
    private static final String ENABLED_PROPERTY = "reporting.enabled";
    private static final String PROJECT_KEY_PROPERTY = "reporting.project-key";
    private static final String HOSTNAME_PROPERTY = "reporting.server.hostname";
    private static final String ACCESS_TOKEN_PROPERTY = "reporting.server.access-token";
    private static final String RUN_DISPLAY_NAME_PROPERTY = "reporting.run.display-name";
    private static final String RUN_BUILD_PROPERTY = "reporting.run.build";
    private static final String RUN_ENVIRONMENT_PROPERTY = "reporting.run.environment";
    private static final String RUN_CONTEXT_PROPERTY = "reporting.run.context";
    private static final String RUN_RETRY_KNOWN_ISSUES_PROPERTY = "reporting.run.retry-known-issues";
    private static final String RUN_SUBSTITUTE_REMOTE_WEB_DRIVERS_PROPERTY = "reporting.run.substitute-remote-web-drivers";
    private static final String RUN_TREAT_SKIPS_AS_FAILURES_PROPERTY = "reporting.run.treat-skips-as-failures";
    private static final String RUN_TEST_CASE_STATUS_ON_PASS_PROPERTY = "reporting.run.test-case-status.on-pass";
    private static final String RUN_TEST_CASE_STATUS_ON_FAIL_PROPERTY = "reporting.run.test-case-status.on-fail";
    private static final String RUN_TEST_CASE_STATUS_ON_SKIP_PROPERTY = "reporting.run.test-case-status.on-skip";
    private static final String NOTIFICATION_NOTIFY_ON_EACH_FAILURE_VARIABLE = "reporting.notification.notify-on-each-failure";
    private static final String NOTIFICATION_SLACK_CHANNELS_PROPERTY = "reporting.notification.slack-channels";
    private static final String NOTIFICATION_MS_TEAMS_CHANNELS_PROPERTY = "reporting.notification.ms-teams-channels";
    private static final String NOTIFICATION_EMAILS_PROPERTY = "reporting.notification.emails";
    private static final String MILESTONE_ID_PROPERTY = "reporting.milestone.id";
    private static final String MILESTONE_NAME_PROPERTY = "reporting.milestone.name";
    private static final String[] DEFAULT_FILE_NAMES = new String[]{"agent.yaml", "agent.yml"};
    private static final Yaml YAML_MAPPER = new Yaml();

    @Override
    public ReportingConfiguration getConfiguration() {
        Map<String, Object> yamlProperties = YamlConfigurationProvider.loadYaml();
        String enabled = YamlConfigurationProvider.getProperty(yamlProperties, ENABLED_PROPERTY);
        String projectKey = YamlConfigurationProvider.getProperty(yamlProperties, PROJECT_KEY_PROPERTY);
        String hostname = YamlConfigurationProvider.getProperty(yamlProperties, HOSTNAME_PROPERTY);
        String accessToken = YamlConfigurationProvider.getProperty(yamlProperties, ACCESS_TOKEN_PROPERTY);
        String displayName = YamlConfigurationProvider.getProperty(yamlProperties, RUN_DISPLAY_NAME_PROPERTY);
        String build = YamlConfigurationProvider.getProperty(yamlProperties, RUN_BUILD_PROPERTY);
        String environment = YamlConfigurationProvider.getProperty(yamlProperties, RUN_ENVIRONMENT_PROPERTY);
        String runContext = YamlConfigurationProvider.getProperty(yamlProperties, RUN_CONTEXT_PROPERTY);
        Boolean runRetryKnownIssues = ConfigurationUtils.parseBoolean(YamlConfigurationProvider.getProperty(yamlProperties, RUN_RETRY_KNOWN_ISSUES_PROPERTY));
        Boolean substituteRemoteWebDrivers = ConfigurationUtils.parseBoolean(YamlConfigurationProvider.getProperty(yamlProperties, RUN_SUBSTITUTE_REMOTE_WEB_DRIVERS_PROPERTY));
        Boolean treatSkipsAsFailures = ConfigurationUtils.parseBoolean(YamlConfigurationProvider.getProperty(yamlProperties, RUN_TREAT_SKIPS_AS_FAILURES_PROPERTY));
        String testCaseStatusOnPass = YamlConfigurationProvider.getProperty(yamlProperties, RUN_TEST_CASE_STATUS_ON_PASS_PROPERTY);
        String testCaseStatusOnFail = YamlConfigurationProvider.getProperty(yamlProperties, RUN_TEST_CASE_STATUS_ON_FAIL_PROPERTY);
        String testCaseStatusOnSkip = YamlConfigurationProvider.getProperty(yamlProperties, RUN_TEST_CASE_STATUS_ON_SKIP_PROPERTY);
        Boolean notifyOnEachFailure = ConfigurationUtils.parseBoolean(System.getenv(NOTIFICATION_NOTIFY_ON_EACH_FAILURE_VARIABLE));
        String slackChannels = YamlConfigurationProvider.getProperty(yamlProperties, NOTIFICATION_SLACK_CHANNELS_PROPERTY);
        String msTeamsChannels = YamlConfigurationProvider.getProperty(yamlProperties, NOTIFICATION_MS_TEAMS_CHANNELS_PROPERTY);
        String emails = YamlConfigurationProvider.getProperty(yamlProperties, NOTIFICATION_EMAILS_PROPERTY);
        Long milestoneId = ConfigurationUtils.parseLong(YamlConfigurationProvider.getProperty(yamlProperties, MILESTONE_ID_PROPERTY));
        String milestoneName = YamlConfigurationProvider.getProperty(yamlProperties, MILESTONE_NAME_PROPERTY);
        if (enabled != null && !"true".equalsIgnoreCase(enabled) && !"false".equalsIgnoreCase(enabled)) {
            throw new TestAgentException("YAML configuration is malformed");
        }
        return ReportingConfiguration.builder().reportingEnabled(ConfigurationUtils.parseBoolean(enabled)).projectKey(projectKey).server(new ReportingConfiguration.ServerConfiguration(hostname, accessToken)).run(new ReportingConfiguration.RunConfiguration(displayName, build, environment, runContext, runRetryKnownIssues, substituteRemoteWebDrivers, treatSkipsAsFailures, new ReportingConfiguration.RunConfiguration.TestCaseStatus(testCaseStatusOnPass, testCaseStatusOnFail, testCaseStatusOnSkip))).milestone(new ReportingConfiguration.MilestoneConfiguration(milestoneId, milestoneName)).notification(new ReportingConfiguration.NotificationConfiguration(notifyOnEachFailure, slackChannels, msTeamsChannels, emails)).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Object> loadYaml() {
        String[] stringArray = DEFAULT_FILE_NAMES;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            try (InputStream resource = YamlConfigurationProvider.class.getClassLoader().getResourceAsStream(filename);){
                if (resource != null) {
                    Map map = (Map)YAML_MAPPER.load(resource);
                    return map;
                }
            }
            catch (IOException e) {
                throw new TestAgentException("Unable to load agent configuration from YAML file");
            }
            ++n2;
        }
        return Collections.emptyMap();
    }

    private static String getProperty(Map<String, Object> yamlProperties, String key) {
        String keySlice;
        Object sliceValue;
        String result = null;
        String[] keySlices = key.split("\\.");
        Map<String, Object> slice = new HashMap<String, Object>(yamlProperties);
        for (int i = 0; i < keySlices.length && (sliceValue = slice.get(keySlice = keySlices[i])) != null; ++i) {
            if (!(sliceValue instanceof Map)) {
                if (i != keySlices.length - 1) break;
                result = sliceValue.toString();
                break;
            }
            slice = (Map)sliceValue;
        }
        return result;
    }
}

