/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.registrar;

import com.zebrunner.agent.core.exception.ArtifactUploadException;
import com.zebrunner.agent.core.registrar.RunContext;
import com.zebrunner.agent.core.registrar.ZebrunnerApiClient;
import com.zebrunner.agent.core.registrar.descriptor.TestDescriptor;
import com.zebrunner.agent.core.registrar.domain.ArtifactReferenceDTO;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Artifact {
    private static final Logger log = LoggerFactory.getLogger(Artifact.class);
    private static final ExecutorService UPLOAD_EXECUTOR = Executors.newFixedThreadPool(8);
    private static final ZebrunnerApiClient API_CLIENT = ZebrunnerApiClient.getInstance();

    private static void shutdown() {
        UPLOAD_EXECUTOR.shutdown();
        try {
            if (!UPLOAD_EXECUTOR.awaitTermination(60L, TimeUnit.SECONDS)) {
                UPLOAD_EXECUTOR.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void attachToTestRun(String name, InputStream artifact) {
        Long testRunId = RunContext.getZebrunnerRunId();
        if (testRunId == null) {
            log.error("Failed to attach artifact '{}' to test run because it has not been started yet.", (Object)name);
        }
        UPLOAD_EXECUTOR.execute(() -> API_CLIENT.uploadTestRunArtifact(artifact, name, testRunId));
    }

    public static void attachToTestRun(String name, byte[] artifact) {
        Artifact.attachToTestRun(name, new ByteArrayInputStream(artifact));
    }

    public static void attachToTestRun(String name, File artifact) {
        try {
            Artifact.attachToTestRun(name, new FileInputStream(artifact));
        }
        catch (FileNotFoundException e) {
            throw new ArtifactUploadException("Unable to upload artifact with name " + name, e);
        }
    }

    public static void attachToTestRun(String name, Path artifact) {
        try {
            Artifact.attachToTestRun(name, Files.newInputStream(artifact, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new ArtifactUploadException("Unable to upload artifact with name " + name, e);
        }
    }

    public static void attachReferenceToTestRun(String name, String reference) {
        ArtifactReferenceDTO artifactReference = Artifact.validateAndConvert(name, reference);
        Long runId = RunContext.getZebrunnerRunId();
        if (runId == null) {
            log.error("Failed to attach artifact reference '{}' to test run because it has not been started yet.", (Object)name);
        }
        API_CLIENT.attachArtifactReferenceToTestRun(runId, artifactReference);
    }

    public static void attachToTest(String name, InputStream artifact) {
        Optional<Long> maybeTestId;
        Long runId = RunContext.getZebrunnerRunId();
        if (runId == null) {
            log.error("Failed to attach artifact '{}' to test because test run has not been started yet.", (Object)name);
        }
        if ((maybeTestId = RunContext.getCurrentTest().map(TestDescriptor::getZebrunnerId)).isPresent()) {
            Long testId = maybeTestId.get();
            UPLOAD_EXECUTOR.execute(() -> API_CLIENT.uploadTestArtifact(artifact, name, runId, testId));
        } else {
            log.error("Failed to attach artifact '{}' to test because it has not been started yet.", (Object)name);
        }
    }

    public static void attachToTest(String name, byte[] artifact) {
        Artifact.attachToTest(name, new ByteArrayInputStream(artifact));
    }

    public static void attachToTest(String name, File artifact) {
        try {
            Artifact.attachToTest(name, new FileInputStream(artifact));
        }
        catch (FileNotFoundException e) {
            throw new ArtifactUploadException("Unable to upload artifact with name " + name, e);
        }
    }

    public static void attachToTest(String name, Path artifact) {
        try {
            Artifact.attachToTest(name, Files.newInputStream(artifact, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new ArtifactUploadException("Unable to upload artifact with name " + name, e);
        }
    }

    public static void attachReferenceToTest(String name, String reference) {
        Optional<Long> maybeTestId;
        ArtifactReferenceDTO artifactReference = Artifact.validateAndConvert(name, reference);
        Long runId = RunContext.getZebrunnerRunId();
        if (runId == null) {
            log.error("Failed to attach artifact reference '{}' to test because test run has not been started yet.", (Object)name);
        }
        if ((maybeTestId = RunContext.getCurrentTest().map(TestDescriptor::getZebrunnerId)).isPresent()) {
            Long testId = maybeTestId.get();
            UPLOAD_EXECUTOR.execute(() -> API_CLIENT.attachArtifactReferenceToTest(runId, testId, artifactReference));
        } else {
            log.error("Failed to attach artifact reference '{}' to test because it has not been started yet.", (Object)name);
        }
    }

    private static ArtifactReferenceDTO validateAndConvert(String name, String reference) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Artifact reference name is not provided.");
        }
        if (reference == null || reference.trim().isEmpty()) {
            throw new IllegalArgumentException("Artifact reference is not provided.");
        }
        return new ArtifactReferenceDTO(name, reference);
    }

    private Artifact() {
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(Artifact::shutdown));
    }
}

