/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.registrar;

import com.zebrunner.agent.core.exception.TestAgentException;
import com.zebrunner.agent.core.registrar.Label;
import com.zebrunner.agent.core.registrar.RunContext;
import com.zebrunner.agent.core.registrar.ZebrunnerApiClient;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentTestRun {
    private static final Logger log = LoggerFactory.getLogger(CurrentTestRun.class);
    private static final ZebrunnerApiClient API_CLIENT = ZebrunnerApiClient.getInstance();

    public static Optional<Long> getId() {
        return Optional.ofNullable(RunContext.getZebrunnerRunId());
    }

    public static void setBuild(String build) {
        if (build == null || build.trim().isEmpty()) {
            throw new TestAgentException("Test Run build must not be empty.");
        }
        Long runId = RunContext.getZebrunnerRunId();
        if (runId != null) {
            API_CLIENT.patchTestRunBuild(runId, build);
        }
    }

    public static void setLocale(String locale) {
        if (locale == null || locale.trim().isEmpty()) {
            throw new TestAgentException("Test Run locale must not be empty.");
        }
        Label.attachToTestRun("com.zebrunner.app/sut.locale", locale);
    }

    public static void setPlatform(String name) {
        CurrentTestRun.setPlatform(name, null);
    }

    public static void setPlatform(String name, String version) {
        if (name == null || name.trim().isEmpty()) {
            throw new TestAgentException("Test Run platform name must not be empty.");
        }
        Long runId = RunContext.getZebrunnerRunId();
        if (runId != null) {
            API_CLIENT.setTestRunPlatform(runId, name, version);
        }
    }
}

