/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.webdriver;

import com.zebrunner.agent.core.registrar.domain.ObjectMapperImpl;
import com.zebrunner.agent.core.webdriver.CapabilitiesCustomizer;
import java.util.Map;
import kong.unirest.GenericType;
import kong.unirest.ObjectMapper;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZebrunnerCapabilitiesCustomizer
implements CapabilitiesCustomizer {
    private static final Logger log = LoggerFactory.getLogger(ZebrunnerCapabilitiesCustomizer.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperImpl();
    private static final GenericType<Map<String, String>> CAPABILITIES_TYPE = new GenericType<Map<String, String>>(){};

    @Override
    public Capabilities customize(Capabilities capabilities) {
        String zebrunnerCapabilities = System.getenv("ZEBRUNNER_CAPABILITIES");
        if (zebrunnerCapabilities != null) {
            log.debug("Capabilities will be modified with the values provided from Zebrunner.");
            Map capabilitiesMap = (Map)OBJECT_MAPPER.readValue(zebrunnerCapabilities, CAPABILITIES_TYPE);
            return capabilities.merge((Capabilities)new DesiredCapabilities(capabilitiesMap));
        }
        return capabilities;
    }
}

