/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.config;

import com.google.gson.Gson;
import com.zebrunner.agent.core.config.ConfigurationProvider;
import com.zebrunner.agent.core.config.ConfigurationProvidersChain;
import com.zebrunner.agent.core.config.ReportingConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class ConfigurationHolder {
    private static final ConfigurationProvidersChain CONFIGURATION_PROVIDERS_CHAIN = ConfigurationProvidersChain.getInstance();
    private static ReportingConfiguration configuration = CONFIGURATION_PROVIDERS_CHAIN.getConfiguration();

    public static void addConfigurationProviderAfter(ConfigurationProvider configurationProvider, Class<? extends ConfigurationProvider> afterProviderWithClass) {
        List<ConfigurationProvider> configurationProviders = CONFIGURATION_PROVIDERS_CHAIN.getConfigurationProviders();
        boolean added = false;
        for (int i = 0; i < configurationProviders.size() - 1; ++i) {
            ConfigurationProvider existingConfigurationProvider = configurationProviders.get(i);
            if (!afterProviderWithClass.isInstance(existingConfigurationProvider)) continue;
            configurationProviders.add(i + 1, configurationProvider);
            added = true;
        }
        if (!added) {
            configurationProviders.add(configurationProvider);
        }
        configuration = CONFIGURATION_PROVIDERS_CHAIN.getConfiguration();
    }

    public static boolean isReportingEnabled() {
        return configuration.isReportingEnabled();
    }

    public static String getProjectKey() {
        return configuration.getProjectKey();
    }

    public static String getHost() {
        return configuration.getServer().getHostname();
    }

    public static String getToken() {
        return configuration.getServer().getAccessToken();
    }

    public static String getRunDisplayNameOr(String displayName) {
        String RUN_DISPLAY_NAME = configuration.getRun().getDisplayName();
        return RUN_DISPLAY_NAME != null ? RUN_DISPLAY_NAME : displayName;
    }

    public static String getRunBuild() {
        return configuration.getRun().getBuild();
    }

    public static String getRunEnvironment() {
        return configuration.getRun().getEnvironment();
    }

    public static String getRunContext() {
        return Optional.ofNullable(System.getProperty("ci_run_id")).map(ConfigurationHolder::toSerializedRunContext).orElseGet(() -> configuration.getRun().getContext());
    }

    public static boolean shouldRetryKnownIssues() {
        Boolean retryKnownIssues = configuration.getRun().getRetryKnownIssues();
        return retryKnownIssues != null && retryKnownIssues != false;
    }

    public static boolean shouldSubstituteRemoteWebDrivers() {
        Boolean substituteRemoteWebDrivers = configuration.getRun().getSubstituteRemoteWebDrivers();
        return substituteRemoteWebDrivers != null && substituteRemoteWebDrivers != false;
    }

    public static boolean shouldTreatSkipsAsFailures() {
        Boolean treatSkipsAsFailures = configuration.getRun().getTreatSkipsAsFailures();
        return treatSkipsAsFailures == null || treatSkipsAsFailures != false;
    }

    public static String getTestCaseStatusOnPass() {
        return configuration.getTcm().getTestCaseStatus().getOnPass();
    }

    public static String getTestCaseStatusOnFail() {
        return configuration.getTcm().getTestCaseStatus().getOnFail();
    }

    public static String getTestCaseStatusOnSkip() {
        return configuration.getTcm().getTestCaseStatus().getOnSkip();
    }

    private static String toSerializedRunContext(String ciRunId) {
        HashMap<String, Object> runContext = new HashMap<String, Object>();
        runContext.put("id", ciRunId);
        if ("true".equalsIgnoreCase(System.getProperty("rerun_failures"))) {
            runContext.put("rerunOnlyFailures", true);
            runContext.put("statuses", Arrays.asList("FAILED", "SKIPPED", "ABORTED", "IN_PROGRESS"));
        }
        return new Gson().toJson(runContext);
    }

    public static boolean notificationsEnabled() {
        Boolean enabled = configuration.getNotification().getEnabled();
        return enabled == null || enabled != false;
    }

    public static boolean shouldNotifyOnEachFailure() {
        Boolean notifyOnEachFailure = configuration.getNotification().getNotifyOnEachFailure();
        return notifyOnEachFailure != null && notifyOnEachFailure != false;
    }

    public static String getSlackChannels() {
        return configuration.getNotification().getSlackChannels();
    }

    public static String getMsTeamsChannels() {
        return configuration.getNotification().getMsTeamsChannels();
    }

    public static String getEmails() {
        return configuration.getNotification().getEmails();
    }

    public static Long getMilestoneId() {
        return configuration.getMilestone().getId();
    }

    public static String getMilestoneName() {
        return configuration.getMilestone().getName();
    }

    public static boolean isTcmSyncEnabled() {
        Boolean pushResults = configuration.getTcm().getZebrunner().getPushResults();
        return pushResults == null || pushResults != false;
    }

    public static boolean isTcmRealTimeSyncEnabled() {
        Boolean pushInRealTime = configuration.getTcm().getZebrunner().getPushInRealTime();
        return pushInRealTime != null && pushInRealTime != false;
    }

    public static String getTcmTestRunId() {
        return configuration.getTcm().getZebrunner().getTestRunId();
    }

    public static boolean isTestRailSyncEnabled() {
        Boolean pushResults = configuration.getTcm().getTestRail().getPushResults();
        return pushResults == null || pushResults != false;
    }

    public static boolean isTestRailRealTimeSyncEnabled() {
        Boolean pushInRealTime = configuration.getTcm().getTestRail().getPushInRealTime();
        return pushInRealTime != null && pushInRealTime != false;
    }

    public static boolean shouldTestRailIncludeAllTestCasesInNewRun() {
        Boolean includeAllTestCasesInNewRun = configuration.getTcm().getTestRail().getIncludeAllTestCasesInNewRun();
        return includeAllTestCasesInNewRun != null && includeAllTestCasesInNewRun != false;
    }

    public static String getTestRailSuiteId() {
        return configuration.getTcm().getTestRail().getSuiteId();
    }

    public static String getTestRailRunId() {
        return configuration.getTcm().getTestRail().getRunId();
    }

    public static String getTestRailRunName() {
        return configuration.getTcm().getTestRail().getRunName();
    }

    public static String getTestRailMilestoneName() {
        return configuration.getTcm().getTestRail().getMilestoneName();
    }

    public static String getTestRailAssignee() {
        return configuration.getTcm().getTestRail().getAssignee();
    }

    public static boolean isXraySyncEnabled() {
        Boolean pushResults = configuration.getTcm().getXray().getPushResults();
        return pushResults == null || pushResults != false;
    }

    public static boolean isXrayRealTimeSyncEnabled() {
        Boolean pushInRealTime = configuration.getTcm().getXray().getPushInRealTime();
        return pushInRealTime != null && pushInRealTime != false;
    }

    public static String getXrayExecutionKey() {
        return configuration.getTcm().getXray().getExecutionKey();
    }

    public static boolean isZephyrSyncEnabled() {
        Boolean pushResults = configuration.getTcm().getZephyr().getPushResults();
        return pushResults == null || pushResults != false;
    }

    public static boolean isZephyrSyncRealTimeEnabled() {
        Boolean pushInRealTime = configuration.getTcm().getZephyr().getPushInRealTime();
        return pushInRealTime != null && pushInRealTime != false;
    }

    public static String getZephyrJiraProjectKey() {
        return configuration.getTcm().getZephyr().getJiraProjectKey();
    }

    public static String getZephyrTestCycleKey() {
        return configuration.getTcm().getZephyr().getTestCycleKey();
    }
}

