/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.config;

import com.zebrunner.agent.core.config.annotation.Configuration;
import com.zebrunner.agent.core.config.annotation.EnvironmentVariable;
import com.zebrunner.agent.core.config.annotation.PropertiesFileProperty;
import com.zebrunner.agent.core.config.annotation.SystemProperty;
import com.zebrunner.agent.core.config.annotation.YamlProperty;

public class ReportingConfiguration {
    @YamlProperty(value={"reporting.enabled"})
    @SystemProperty(value={"reporting.enabled"})
    @EnvironmentVariable(value="REPORTING_ENABLED")
    @PropertiesFileProperty(value={"reporting.enabled"})
    private Boolean reportingEnabled;
    @EnvironmentVariable(value="REPORTING_PROJECT_KEY")
    @YamlProperty(value={"reporting.project-key", "reporting.projectKey"})
    @SystemProperty(value={"reporting.project-key", "reporting.projectKey"})
    @PropertiesFileProperty(value={"reporting.project-key", "reporting.projectKey"})
    private String projectKey;
    @Configuration
    private ServerConfiguration server;
    @Configuration
    private RunConfiguration run;
    @Configuration
    private MilestoneConfiguration milestone;
    @Configuration
    private NotificationConfiguration notification;
    @Configuration
    private TcmConfiguration tcm;

    public boolean isReportingEnabled() {
        return this.reportingEnabled != null && this.reportingEnabled != false;
    }

    public static ReportingConfigurationBuilder builder() {
        return new ReportingConfigurationBuilder();
    }

    public Boolean getReportingEnabled() {
        return this.reportingEnabled;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public ServerConfiguration getServer() {
        return this.server;
    }

    public RunConfiguration getRun() {
        return this.run;
    }

    public MilestoneConfiguration getMilestone() {
        return this.milestone;
    }

    public NotificationConfiguration getNotification() {
        return this.notification;
    }

    public TcmConfiguration getTcm() {
        return this.tcm;
    }

    public void setReportingEnabled(Boolean reportingEnabled) {
        this.reportingEnabled = reportingEnabled;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public void setServer(ServerConfiguration server) {
        this.server = server;
    }

    public void setRun(RunConfiguration run) {
        this.run = run;
    }

    public void setMilestone(MilestoneConfiguration milestone) {
        this.milestone = milestone;
    }

    public void setNotification(NotificationConfiguration notification) {
        this.notification = notification;
    }

    public void setTcm(TcmConfiguration tcm) {
        this.tcm = tcm;
    }

    public ReportingConfiguration() {
    }

    public ReportingConfiguration(Boolean reportingEnabled, String projectKey, ServerConfiguration server, RunConfiguration run, MilestoneConfiguration milestone, NotificationConfiguration notification, TcmConfiguration tcm) {
        this.reportingEnabled = reportingEnabled;
        this.projectKey = projectKey;
        this.server = server;
        this.run = run;
        this.milestone = milestone;
        this.notification = notification;
        this.tcm = tcm;
    }

    public static class ReportingConfigurationBuilder {
        private Boolean reportingEnabled;
        private String projectKey;
        private ServerConfiguration server;
        private RunConfiguration run;
        private MilestoneConfiguration milestone;
        private NotificationConfiguration notification;
        private TcmConfiguration tcm;

        ReportingConfigurationBuilder() {
        }

        public ReportingConfigurationBuilder reportingEnabled(Boolean reportingEnabled) {
            this.reportingEnabled = reportingEnabled;
            return this;
        }

        public ReportingConfigurationBuilder projectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public ReportingConfigurationBuilder server(ServerConfiguration server) {
            this.server = server;
            return this;
        }

        public ReportingConfigurationBuilder run(RunConfiguration run) {
            this.run = run;
            return this;
        }

        public ReportingConfigurationBuilder milestone(MilestoneConfiguration milestone) {
            this.milestone = milestone;
            return this;
        }

        public ReportingConfigurationBuilder notification(NotificationConfiguration notification) {
            this.notification = notification;
            return this;
        }

        public ReportingConfigurationBuilder tcm(TcmConfiguration tcm) {
            this.tcm = tcm;
            return this;
        }

        public ReportingConfiguration build() {
            return new ReportingConfiguration(this.reportingEnabled, this.projectKey, this.server, this.run, this.milestone, this.notification, this.tcm);
        }

        public String toString() {
            return "ReportingConfiguration.ReportingConfigurationBuilder(reportingEnabled=" + this.reportingEnabled + ", projectKey=" + this.projectKey + ", server=" + this.server + ", run=" + this.run + ", milestone=" + this.milestone + ", notification=" + this.notification + ", tcm=" + this.tcm + ")";
        }
    }

    public static class TcmConfiguration {
        @Configuration
        private TestCaseStatus testCaseStatus = new TestCaseStatus();
        @Configuration
        private Zebrunner zebrunner = new Zebrunner();
        @Configuration
        private TestRail testRail = new TestRail();
        @Configuration
        private Xray xray = new Xray();
        @Configuration
        private Zephyr zephyr = new Zephyr();

        public TestCaseStatus getTestCaseStatus() {
            return this.testCaseStatus;
        }

        public Zebrunner getZebrunner() {
            return this.zebrunner;
        }

        public TestRail getTestRail() {
            return this.testRail;
        }

        public Xray getXray() {
            return this.xray;
        }

        public Zephyr getZephyr() {
            return this.zephyr;
        }

        public void setTestCaseStatus(TestCaseStatus testCaseStatus) {
            this.testCaseStatus = testCaseStatus;
        }

        public void setZebrunner(Zebrunner zebrunner) {
            this.zebrunner = zebrunner;
        }

        public void setTestRail(TestRail testRail) {
            this.testRail = testRail;
        }

        public void setXray(Xray xray) {
            this.xray = xray;
        }

        public void setZephyr(Zephyr zephyr) {
            this.zephyr = zephyr;
        }

        public TcmConfiguration() {
        }

        public TcmConfiguration(TestCaseStatus testCaseStatus, Zebrunner zebrunner, TestRail testRail, Xray xray, Zephyr zephyr) {
            this.testCaseStatus = testCaseStatus;
            this.zebrunner = zebrunner;
            this.testRail = testRail;
            this.xray = xray;
            this.zephyr = zephyr;
        }

        public static class Zephyr {
            @YamlProperty(value={"reporting.tcm.zephyr.push-results"})
            @SystemProperty(value={"reporting.tcm.zephyr.push-results"})
            @EnvironmentVariable(value="REPORTING_TCM_ZEPHYR_PUSH_RESULTS")
            @PropertiesFileProperty(value={"reporting.tcm.zephyr.push-results"})
            private Boolean pushResults;
            @YamlProperty(value={"reporting.tcm.zephyr.push-in-real-time"})
            @SystemProperty(value={"reporting.tcm.zephyr.push-in-real-time"})
            @EnvironmentVariable(value="REPORTING_TCM_ZEPHYR_PUSH_IN_REAL_TIME")
            @PropertiesFileProperty(value={"reporting.tcm.zephyr.push-in-real-time"})
            private Boolean pushInRealTime;
            @YamlProperty(value={"reporting.tcm.zephyr.jira-project-key"})
            @SystemProperty(value={"reporting.tcm.zephyr.jira-project-key"})
            @EnvironmentVariable(value="REPORTING_TCM_ZEPHYR_JIRA_PROJECT_KEY")
            @PropertiesFileProperty(value={"reporting.tcm.zephyr.jira-project-key"})
            private String jiraProjectKey;
            @YamlProperty(value={"reporting.tcm.zephyr.test-cycle-key"})
            @SystemProperty(value={"reporting.tcm.zephyr.test-cycle-key"})
            @EnvironmentVariable(value="REPORTING_TCM_ZEPHYR_TEST_CYCLE_KEY")
            @PropertiesFileProperty(value={"reporting.tcm.zephyr.test-cycle-key"})
            private String testCycleKey;

            public Boolean getPushResults() {
                return this.pushResults;
            }

            public Boolean getPushInRealTime() {
                return this.pushInRealTime;
            }

            public String getJiraProjectKey() {
                return this.jiraProjectKey;
            }

            public String getTestCycleKey() {
                return this.testCycleKey;
            }

            public void setPushResults(Boolean pushResults) {
                this.pushResults = pushResults;
            }

            public void setPushInRealTime(Boolean pushInRealTime) {
                this.pushInRealTime = pushInRealTime;
            }

            public void setJiraProjectKey(String jiraProjectKey) {
                this.jiraProjectKey = jiraProjectKey;
            }

            public void setTestCycleKey(String testCycleKey) {
                this.testCycleKey = testCycleKey;
            }

            public Zephyr() {
            }

            public Zephyr(Boolean pushResults, Boolean pushInRealTime, String jiraProjectKey, String testCycleKey) {
                this.pushResults = pushResults;
                this.pushInRealTime = pushInRealTime;
                this.jiraProjectKey = jiraProjectKey;
                this.testCycleKey = testCycleKey;
            }
        }

        public static class Xray {
            @YamlProperty(value={"reporting.tcm.xray.push-results"})
            @SystemProperty(value={"reporting.tcm.xray.push-results"})
            @EnvironmentVariable(value="REPORTING_TCM_XRAY_PUSH_RESULTS")
            @PropertiesFileProperty(value={"reporting.tcm.xray.push-results"})
            private Boolean pushResults;
            @YamlProperty(value={"reporting.tcm.xray.push-in-real-time"})
            @SystemProperty(value={"reporting.tcm.xray.push-in-real-time"})
            @EnvironmentVariable(value="REPORTING_TCM_XRAY_PUSH_IN_REAL_TIME")
            @PropertiesFileProperty(value={"reporting.tcm.xray.push-in-real-time"})
            private Boolean pushInRealTime;
            @YamlProperty(value={"reporting.tcm.xray.execution-key"})
            @SystemProperty(value={"reporting.tcm.xray.execution-key"})
            @EnvironmentVariable(value="REPORTING_TCM_XRAY_EXECUTION_KEY")
            @PropertiesFileProperty(value={"reporting.tcm.xray.execution-key"})
            private String executionKey;

            public Boolean getPushResults() {
                return this.pushResults;
            }

            public Boolean getPushInRealTime() {
                return this.pushInRealTime;
            }

            public String getExecutionKey() {
                return this.executionKey;
            }

            public void setPushResults(Boolean pushResults) {
                this.pushResults = pushResults;
            }

            public void setPushInRealTime(Boolean pushInRealTime) {
                this.pushInRealTime = pushInRealTime;
            }

            public void setExecutionKey(String executionKey) {
                this.executionKey = executionKey;
            }

            public Xray() {
            }

            public Xray(Boolean pushResults, Boolean pushInRealTime, String executionKey) {
                this.pushResults = pushResults;
                this.pushInRealTime = pushInRealTime;
                this.executionKey = executionKey;
            }
        }

        public static class TestRail {
            @YamlProperty(value={"reporting.tcm.test-rail.push-results"})
            @SystemProperty(value={"reporting.tcm.test-rail.push-results"})
            @EnvironmentVariable(value="REPORTING_TCM_TEST_RAIL_PUSH_RESULTS")
            @PropertiesFileProperty(value={"reporting.tcm.test-rail.push-results"})
            private Boolean pushResults;
            @YamlProperty(value={"reporting.tcm.test-rail.push-in-real-time"})
            @SystemProperty(value={"reporting.tcm.test-rail.push-in-real-time"})
            @EnvironmentVariable(value="REPORTING_TCM_TEST_RAIL_PUSH_IN_REAL_TIME")
            @PropertiesFileProperty(value={"reporting.tcm.test-rail.push-in-real-time"})
            private Boolean pushInRealTime;
            @YamlProperty(value={"reporting.tcm.test-rail.suite-id"})
            @SystemProperty(value={"reporting.tcm.test-rail.suite-id"})
            @EnvironmentVariable(value="REPORTING_TCM_TEST_RAIL_SUITE_ID")
            @PropertiesFileProperty(value={"reporting.tcm.test-rail.suite-id"})
            private String suiteId;
            @YamlProperty(value={"reporting.tcm.test-rail.run-id"})
            @SystemProperty(value={"reporting.tcm.test-rail.run-id"})
            @EnvironmentVariable(value="REPORTING_TCM_TEST_RAIL_RUN_ID")
            @PropertiesFileProperty(value={"reporting.tcm.test-rail.run-id"})
            private String runId;
            @YamlProperty(value={"reporting.tcm.test-rail.include-all-test-cases-in-new-run"})
            @SystemProperty(value={"reporting.tcm.test-rail.include-all-test-cases-in-new-run"})
            @EnvironmentVariable(value="REPORTING_TCM_TEST_RAIL_INCLUDE_ALL_TEST_CASES_IN_NEW_RUN")
            @PropertiesFileProperty(value={"reporting.tcm.test-rail.include-all-test-cases-in-new-run"})
            private Boolean includeAllTestCasesInNewRun;
            @YamlProperty(value={"reporting.tcm.test-rail.run-name"})
            @SystemProperty(value={"reporting.tcm.test-rail.run-name"})
            @EnvironmentVariable(value="REPORTING_TCM_TEST_RAIL_RUN_NAME")
            @PropertiesFileProperty(value={"reporting.tcm.test-rail.run-name"})
            private String runName;
            @YamlProperty(value={"reporting.tcm.test-rail.milestone-name"})
            @SystemProperty(value={"reporting.tcm.test-rail.milestone-name"})
            @EnvironmentVariable(value="REPORTING_TCM_TEST_RAIL_MILESTONE_NAME")
            @PropertiesFileProperty(value={"reporting.tcm.test-rail.milestone-name"})
            private String milestoneName;
            @YamlProperty(value={"reporting.tcm.test-rail.assignee"})
            @SystemProperty(value={"reporting.tcm.test-rail.assignee"})
            @EnvironmentVariable(value="REPORTING_TCM_TEST_RAIL_ASSIGNEE")
            @PropertiesFileProperty(value={"reporting.tcm.test-rail.assignee"})
            private String assignee;

            public static TestRailBuilder builder() {
                return new TestRailBuilder();
            }

            public Boolean getPushResults() {
                return this.pushResults;
            }

            public Boolean getPushInRealTime() {
                return this.pushInRealTime;
            }

            public String getSuiteId() {
                return this.suiteId;
            }

            public String getRunId() {
                return this.runId;
            }

            public Boolean getIncludeAllTestCasesInNewRun() {
                return this.includeAllTestCasesInNewRun;
            }

            public String getRunName() {
                return this.runName;
            }

            public String getMilestoneName() {
                return this.milestoneName;
            }

            public String getAssignee() {
                return this.assignee;
            }

            public void setPushResults(Boolean pushResults) {
                this.pushResults = pushResults;
            }

            public void setPushInRealTime(Boolean pushInRealTime) {
                this.pushInRealTime = pushInRealTime;
            }

            public void setSuiteId(String suiteId) {
                this.suiteId = suiteId;
            }

            public void setRunId(String runId) {
                this.runId = runId;
            }

            public void setIncludeAllTestCasesInNewRun(Boolean includeAllTestCasesInNewRun) {
                this.includeAllTestCasesInNewRun = includeAllTestCasesInNewRun;
            }

            public void setRunName(String runName) {
                this.runName = runName;
            }

            public void setMilestoneName(String milestoneName) {
                this.milestoneName = milestoneName;
            }

            public void setAssignee(String assignee) {
                this.assignee = assignee;
            }

            public TestRail() {
            }

            public TestRail(Boolean pushResults, Boolean pushInRealTime, String suiteId, String runId, Boolean includeAllTestCasesInNewRun, String runName, String milestoneName, String assignee) {
                this.pushResults = pushResults;
                this.pushInRealTime = pushInRealTime;
                this.suiteId = suiteId;
                this.runId = runId;
                this.includeAllTestCasesInNewRun = includeAllTestCasesInNewRun;
                this.runName = runName;
                this.milestoneName = milestoneName;
                this.assignee = assignee;
            }

            public static class TestRailBuilder {
                private Boolean pushResults;
                private Boolean pushInRealTime;
                private String suiteId;
                private String runId;
                private Boolean includeAllTestCasesInNewRun;
                private String runName;
                private String milestoneName;
                private String assignee;

                TestRailBuilder() {
                }

                public TestRailBuilder pushResults(Boolean pushResults) {
                    this.pushResults = pushResults;
                    return this;
                }

                public TestRailBuilder pushInRealTime(Boolean pushInRealTime) {
                    this.pushInRealTime = pushInRealTime;
                    return this;
                }

                public TestRailBuilder suiteId(String suiteId) {
                    this.suiteId = suiteId;
                    return this;
                }

                public TestRailBuilder runId(String runId) {
                    this.runId = runId;
                    return this;
                }

                public TestRailBuilder includeAllTestCasesInNewRun(Boolean includeAllTestCasesInNewRun) {
                    this.includeAllTestCasesInNewRun = includeAllTestCasesInNewRun;
                    return this;
                }

                public TestRailBuilder runName(String runName) {
                    this.runName = runName;
                    return this;
                }

                public TestRailBuilder milestoneName(String milestoneName) {
                    this.milestoneName = milestoneName;
                    return this;
                }

                public TestRailBuilder assignee(String assignee) {
                    this.assignee = assignee;
                    return this;
                }

                public TestRail build() {
                    return new TestRail(this.pushResults, this.pushInRealTime, this.suiteId, this.runId, this.includeAllTestCasesInNewRun, this.runName, this.milestoneName, this.assignee);
                }

                public String toString() {
                    return "ReportingConfiguration.TcmConfiguration.TestRail.TestRailBuilder(pushResults=" + this.pushResults + ", pushInRealTime=" + this.pushInRealTime + ", suiteId=" + this.suiteId + ", runId=" + this.runId + ", includeAllTestCasesInNewRun=" + this.includeAllTestCasesInNewRun + ", runName=" + this.runName + ", milestoneName=" + this.milestoneName + ", assignee=" + this.assignee + ")";
                }
            }
        }

        public static class Zebrunner {
            @YamlProperty(value={"reporting.tcm.zebrunner.push-results"})
            @SystemProperty(value={"reporting.tcm.zebrunner.push-results"})
            @EnvironmentVariable(value="REPORTING_TCM_ZEBRUNNER_PUSH_RESULTS")
            @PropertiesFileProperty(value={"reporting.tcm.zebrunner.push-results"})
            private Boolean pushResults;
            @YamlProperty(value={"reporting.tcm.zebrunner.push-in-real-time"})
            @SystemProperty(value={"reporting.tcm.zebrunner.push-in-real-time"})
            @EnvironmentVariable(value="REPORTING_TCM_ZEBRUNNER_PUSH_IN_REAL_TIME")
            @PropertiesFileProperty(value={"reporting.tcm.zebrunner.push-in-real-time"})
            private Boolean pushInRealTime;
            @EnvironmentVariable(value="REPORTING_TCM_ZEBRUNNER_RUN_ID")
            @YamlProperty(value={"reporting.tcm.zebrunner.test-run-id", "reporting.tcm.zebrunner.run-id"})
            @SystemProperty(value={"reporting.tcm.zebrunner.test-run-id", "reporting.tcm.zebrunner.run-id"})
            @PropertiesFileProperty(value={"reporting.tcm.zebrunner.test-run-id", "reporting.tcm.zebrunner.run-id"})
            private String testRunId;

            public Boolean getPushResults() {
                return this.pushResults;
            }

            public Boolean getPushInRealTime() {
                return this.pushInRealTime;
            }

            public String getTestRunId() {
                return this.testRunId;
            }

            public void setPushResults(Boolean pushResults) {
                this.pushResults = pushResults;
            }

            public void setPushInRealTime(Boolean pushInRealTime) {
                this.pushInRealTime = pushInRealTime;
            }

            public void setTestRunId(String testRunId) {
                this.testRunId = testRunId;
            }

            public Zebrunner() {
            }

            public Zebrunner(Boolean pushResults, Boolean pushInRealTime, String testRunId) {
                this.pushResults = pushResults;
                this.pushInRealTime = pushInRealTime;
                this.testRunId = testRunId;
            }
        }

        public static class TestCaseStatus {
            @YamlProperty(value={"reporting.tcm.test-case-status.on-pass"})
            @SystemProperty(value={"reporting.tcm.test-case-status.on-pass"})
            @EnvironmentVariable(value="REPORTING_TCM_TEST_CASE_STATUS_ON_PASS")
            @PropertiesFileProperty(value={"reporting.tcm.test-case-status.on-pass"})
            private String onPass;
            @YamlProperty(value={"reporting.tcm.test-case-status.on-fail"})
            @SystemProperty(value={"reporting.tcm.test-case-status.on-fail"})
            @EnvironmentVariable(value="REPORTING_TCM_TEST_CASE_STATUS_ON_FAIL")
            @PropertiesFileProperty(value={"reporting.tcm.test-case-status.on-fail"})
            private String onFail;
            @YamlProperty(value={"reporting.tcm.test-case-status.on-skip"})
            @SystemProperty(value={"reporting.tcm.test-case-status.on-skip"})
            @EnvironmentVariable(value="REPORTING_TCM_TEST_CASE_STATUS_ON_SKIP")
            @PropertiesFileProperty(value={"reporting.tcm.test-case-status.on-skip"})
            private String onSkip;

            public String getOnPass() {
                return this.onPass;
            }

            public String getOnFail() {
                return this.onFail;
            }

            public String getOnSkip() {
                return this.onSkip;
            }

            public void setOnPass(String onPass) {
                this.onPass = onPass;
            }

            public void setOnFail(String onFail) {
                this.onFail = onFail;
            }

            public void setOnSkip(String onSkip) {
                this.onSkip = onSkip;
            }

            public TestCaseStatus() {
            }

            public TestCaseStatus(String onPass, String onFail, String onSkip) {
                this.onPass = onPass;
                this.onFail = onFail;
                this.onSkip = onSkip;
            }
        }
    }

    public static class NotificationConfiguration {
        @YamlProperty(value={"reporting.notification.enabled"})
        @SystemProperty(value={"reporting.notification.enabled"})
        @EnvironmentVariable(value="REPORTING_NOTIFICATION_ENABLED")
        @PropertiesFileProperty(value={"reporting.notification.enabled"})
        private Boolean enabled;
        @YamlProperty(value={"reporting.notification.notify-on-each-failure"})
        @SystemProperty(value={"reporting.notification.notify-on-each-failure"})
        @EnvironmentVariable(value="REPORTING_NOTIFICATION_NOTIFY_ON_EACH_FAILURE")
        @PropertiesFileProperty(value={"reporting.notification.notify-on-each-failure"})
        private Boolean notifyOnEachFailure;
        @YamlProperty(value={"reporting.notification.slack-channels"})
        @SystemProperty(value={"reporting.notification.slack-channels"})
        @EnvironmentVariable(value="REPORTING_NOTIFICATION_SLACK_CHANNELS")
        @PropertiesFileProperty(value={"reporting.notification.slack-channels"})
        private String slackChannels;
        @YamlProperty(value={"reporting.notification.ms-teams-channels"})
        @SystemProperty(value={"reporting.notification.ms-teams-channels"})
        @EnvironmentVariable(value="REPORTING_NOTIFICATION_MS_TEAMS_CHANNELS")
        @PropertiesFileProperty(value={"reporting.notification.ms-teams-channels"})
        private String msTeamsChannels;
        @YamlProperty(value={"reporting.notification.emails"})
        @SystemProperty(value={"reporting.notification.emails"})
        @EnvironmentVariable(value="REPORTING_NOTIFICATION_EMAILS")
        @PropertiesFileProperty(value={"reporting.notification.emails"})
        private String emails;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public Boolean getNotifyOnEachFailure() {
            return this.notifyOnEachFailure;
        }

        public String getSlackChannels() {
            return this.slackChannels;
        }

        public String getMsTeamsChannels() {
            return this.msTeamsChannels;
        }

        public String getEmails() {
            return this.emails;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public void setNotifyOnEachFailure(Boolean notifyOnEachFailure) {
            this.notifyOnEachFailure = notifyOnEachFailure;
        }

        public void setSlackChannels(String slackChannels) {
            this.slackChannels = slackChannels;
        }

        public void setMsTeamsChannels(String msTeamsChannels) {
            this.msTeamsChannels = msTeamsChannels;
        }

        public void setEmails(String emails) {
            this.emails = emails;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NotificationConfiguration)) {
                return false;
            }
            NotificationConfiguration other = (NotificationConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            Boolean this$notifyOnEachFailure = this.getNotifyOnEachFailure();
            Boolean other$notifyOnEachFailure = other.getNotifyOnEachFailure();
            if (this$notifyOnEachFailure == null ? other$notifyOnEachFailure != null : !((Object)this$notifyOnEachFailure).equals(other$notifyOnEachFailure)) {
                return false;
            }
            String this$slackChannels = this.getSlackChannels();
            String other$slackChannels = other.getSlackChannels();
            if (this$slackChannels == null ? other$slackChannels != null : !this$slackChannels.equals(other$slackChannels)) {
                return false;
            }
            String this$msTeamsChannels = this.getMsTeamsChannels();
            String other$msTeamsChannels = other.getMsTeamsChannels();
            if (this$msTeamsChannels == null ? other$msTeamsChannels != null : !this$msTeamsChannels.equals(other$msTeamsChannels)) {
                return false;
            }
            String this$emails = this.getEmails();
            String other$emails = other.getEmails();
            return !(this$emails == null ? other$emails != null : !this$emails.equals(other$emails));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NotificationConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            Boolean $notifyOnEachFailure = this.getNotifyOnEachFailure();
            result = result * 59 + ($notifyOnEachFailure == null ? 43 : ((Object)$notifyOnEachFailure).hashCode());
            String $slackChannels = this.getSlackChannels();
            result = result * 59 + ($slackChannels == null ? 43 : $slackChannels.hashCode());
            String $msTeamsChannels = this.getMsTeamsChannels();
            result = result * 59 + ($msTeamsChannels == null ? 43 : $msTeamsChannels.hashCode());
            String $emails = this.getEmails();
            result = result * 59 + ($emails == null ? 43 : $emails.hashCode());
            return result;
        }

        public String toString() {
            return "ReportingConfiguration.NotificationConfiguration(enabled=" + this.getEnabled() + ", notifyOnEachFailure=" + this.getNotifyOnEachFailure() + ", slackChannels=" + this.getSlackChannels() + ", msTeamsChannels=" + this.getMsTeamsChannels() + ", emails=" + this.getEmails() + ")";
        }

        public NotificationConfiguration() {
        }

        public NotificationConfiguration(Boolean enabled, Boolean notifyOnEachFailure, String slackChannels, String msTeamsChannels, String emails) {
            this.enabled = enabled;
            this.notifyOnEachFailure = notifyOnEachFailure;
            this.slackChannels = slackChannels;
            this.msTeamsChannels = msTeamsChannels;
            this.emails = emails;
        }
    }

    public static class RunConfiguration {
        @EnvironmentVariable(value="REPORTING_RUN_DISPLAY_NAME")
        @YamlProperty(value={"reporting.run.display-name", "reporting.run.displayName"})
        @SystemProperty(value={"reporting.run.display-name", "reporting.run.displayName"})
        @PropertiesFileProperty(value={"reporting.run.display-name", "reporting.run.displayName"})
        private String displayName;
        @YamlProperty(value={"reporting.run.build"})
        @SystemProperty(value={"reporting.run.build"})
        @EnvironmentVariable(value="REPORTING_RUN_BUILD")
        @PropertiesFileProperty(value={"reporting.run.build"})
        private String build;
        @YamlProperty(value={"reporting.run.environment"})
        @SystemProperty(value={"reporting.run.environment"})
        @EnvironmentVariable(value="REPORTING_RUN_ENVIRONMENT")
        @PropertiesFileProperty(value={"reporting.run.environment"})
        private String environment;
        @YamlProperty(value={"reporting.run.context"})
        @SystemProperty(value={"reporting.run.context"})
        @EnvironmentVariable(value="REPORTING_RUN_CONTEXT")
        @PropertiesFileProperty(value={"reporting.run.context"})
        private String context;
        @YamlProperty(value={"reporting.run.retry-known-issues"})
        @EnvironmentVariable(value="REPORTING_RUN_RETRY_KNOWN_ISSUES")
        @PropertiesFileProperty(value={"reporting.run.retry-known-issues"})
        @SystemProperty(value={"reporting.run.retry-known-issues", "reporting.run.retryKnownIssues"})
        private Boolean retryKnownIssues;
        @EnvironmentVariable(value="REPORTING_RUN_SUBSTITUTE_REMOTE_WEB_DRIVERS")
        private Boolean substituteRemoteWebDrivers;
        @YamlProperty(value={"reporting.run.treat-skips-as-failures"})
        @SystemProperty(value={"reporting.run.treat-skips-as-failures"})
        @EnvironmentVariable(value="REPORTING_RUN_TREAT_SKIPS_AS_FAILURES")
        @PropertiesFileProperty(value={"reporting.run.treat-skips-as-failures"})
        private Boolean treatSkipsAsFailures;

        public String getDisplayName() {
            return this.displayName;
        }

        public String getBuild() {
            return this.build;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getContext() {
            return this.context;
        }

        public Boolean getRetryKnownIssues() {
            return this.retryKnownIssues;
        }

        public Boolean getSubstituteRemoteWebDrivers() {
            return this.substituteRemoteWebDrivers;
        }

        public Boolean getTreatSkipsAsFailures() {
            return this.treatSkipsAsFailures;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public void setBuild(String build) {
            this.build = build;
        }

        public void setEnvironment(String environment) {
            this.environment = environment;
        }

        public void setContext(String context) {
            this.context = context;
        }

        public void setRetryKnownIssues(Boolean retryKnownIssues) {
            this.retryKnownIssues = retryKnownIssues;
        }

        public void setSubstituteRemoteWebDrivers(Boolean substituteRemoteWebDrivers) {
            this.substituteRemoteWebDrivers = substituteRemoteWebDrivers;
        }

        public void setTreatSkipsAsFailures(Boolean treatSkipsAsFailures) {
            this.treatSkipsAsFailures = treatSkipsAsFailures;
        }

        public RunConfiguration() {
        }

        public RunConfiguration(String displayName, String build, String environment, String context, Boolean retryKnownIssues, Boolean substituteRemoteWebDrivers, Boolean treatSkipsAsFailures) {
            this.displayName = displayName;
            this.build = build;
            this.environment = environment;
            this.context = context;
            this.retryKnownIssues = retryKnownIssues;
            this.substituteRemoteWebDrivers = substituteRemoteWebDrivers;
            this.treatSkipsAsFailures = treatSkipsAsFailures;
        }
    }

    public static class ServerConfiguration {
        @YamlProperty(value={"reporting.server.hostname"})
        @SystemProperty(value={"reporting.server.hostname"})
        @EnvironmentVariable(value="REPORTING_SERVER_HOSTNAME")
        @PropertiesFileProperty(value={"reporting.server.hostname"})
        private String hostname;
        @YamlProperty(value={"reporting.server.access-token"})
        @EnvironmentVariable(value="REPORTING_SERVER_ACCESS_TOKEN")
        @PropertiesFileProperty(value={"reporting.server.access-token"})
        @SystemProperty(value={"reporting.server.access-token", "reporting.server.accessToken"})
        private String accessToken;

        public String getHostname() {
            return this.hostname;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public ServerConfiguration() {
        }

        public ServerConfiguration(String hostname, String accessToken) {
            this.hostname = hostname;
            this.accessToken = accessToken;
        }
    }

    public static class MilestoneConfiguration {
        @YamlProperty(value={"reporting.milestone.id"})
        @SystemProperty(value={"reporting.milestone.id"})
        @EnvironmentVariable(value="REPORTING_MILESTONE_ID")
        @PropertiesFileProperty(value={"reporting.milestone.id"})
        private Long id;
        @YamlProperty(value={"reporting.milestone.name"})
        @SystemProperty(value={"reporting.milestone.name"})
        @EnvironmentVariable(value="REPORTING_MILESTONE_NAME")
        @PropertiesFileProperty(value={"reporting.milestone.name"})
        private String name;

        public Long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MilestoneConfiguration)) {
                return false;
            }
            MilestoneConfiguration other = (MilestoneConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$id = this.getId();
            Long other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MilestoneConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "ReportingConfiguration.MilestoneConfiguration(id=" + this.getId() + ", name=" + this.getName() + ")";
        }

        public MilestoneConfiguration() {
        }

        public MilestoneConfiguration(Long id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}

