/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.logging.log4j2;

import com.zebrunner.agent.core.logging.Log;
import com.zebrunner.agent.core.registrar.LogsBuffer;
import java.io.Serializable;
import java.util.function.Function;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="ReportingAppender", category="Core", elementType="appender")
public final class ReportingAppender
extends AbstractAppender {
    private static final Function<LogEvent, Log> CONVERTER = e -> Log.builder().message(e.getMessage().getFormattedMessage()).level(e.getLevel().toString()).timestamp(e.getTimeMillis()).build();
    private static volatile LogsBuffer<LogEvent> logsBuffer;

    protected ReportingAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
    }

    @PluginFactory
    public static ReportingAppender create(@PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided for TestLoggerAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new ReportingAppender(name, filter, (Layout<? extends Serializable>)layout, true);
    }

    public void append(LogEvent event) {
        ReportingAppender.getBuffer().put(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LogsBuffer<LogEvent> getBuffer() {
        if (logsBuffer != null) return logsBuffer;
        Class<ReportingAppender> clazz = ReportingAppender.class;
        synchronized (ReportingAppender.class) {
            if (logsBuffer != null) return logsBuffer;
            logsBuffer = LogsBuffer.create(CONVERTER);
            // ** MonitorExit[var0] (shouldn't be in output)
            return logsBuffer;
        }
    }
}

