/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.registrar;

import com.zebrunner.agent.core.config.ConfigurationHolder;
import com.zebrunner.agent.core.registrar.ClientRegistrar;
import com.zebrunner.agent.core.registrar.Label;
import com.zebrunner.agent.core.registrar.RegistrationListenerRegistry;
import com.zebrunner.agent.core.registrar.RerunResolver;
import com.zebrunner.agent.core.registrar.RunContext;
import com.zebrunner.agent.core.registrar.RunContextHolder;
import com.zebrunner.agent.core.registrar.TestRunRegistrar;
import com.zebrunner.agent.core.registrar.TestSessionRegistrar;
import com.zebrunner.agent.core.registrar.ZebrunnerApiClient;
import com.zebrunner.agent.core.registrar.ci.CiContextResolver;
import com.zebrunner.agent.core.registrar.ci.CompositeCiContextResolver;
import com.zebrunner.agent.core.registrar.descriptor.TestDescriptor;
import com.zebrunner.agent.core.registrar.descriptor.TestFinishDescriptor;
import com.zebrunner.agent.core.registrar.descriptor.TestRunDescriptor;
import com.zebrunner.agent.core.registrar.descriptor.TestRunFinishDescriptor;
import com.zebrunner.agent.core.registrar.descriptor.TestRunStartDescriptor;
import com.zebrunner.agent.core.registrar.descriptor.TestStartDescriptor;
import com.zebrunner.agent.core.registrar.domain.NotificationTargetDTO;
import com.zebrunner.agent.core.registrar.domain.TestDTO;
import com.zebrunner.agent.core.registrar.domain.TestRunDTO;
import com.zebrunner.agent.core.registrar.label.CompositeLabelResolver;
import com.zebrunner.agent.core.registrar.maintainer.ChainedMaintainerResolver;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReportingRegistrar
implements TestRunRegistrar {
    private static final Logger log = LoggerFactory.getLogger(ReportingRegistrar.class);
    private static final String TEST_RUN_WARNING_MSG_FORMAT = "[TEST RUN '{}' WARNING]: {}";
    private static volatile ReportingRegistrar instance;
    private final ZebrunnerApiClient apiClient = ClientRegistrar.getClient();
    private final CompositeLabelResolver labelResolver = new CompositeLabelResolver();
    private final ChainedMaintainerResolver maintainerResolver = new ChainedMaintainerResolver();
    private final CiContextResolver ciContextResolver = CompositeCiContextResolver.getInstance();
    private final TestSessionRegistrar testSessionRegistrar = TestSessionRegistrar.getInstance();
    private final RegistrationListenerRegistry registrationListenerRegistry = RegistrationListenerRegistry.getInstance();

    ReportingRegistrar() {
    }

    public static ReportingRegistrar getInstance() {
        if (instance == null) {
            RerunResolver.resolve();
            instance = new ReportingRegistrar();
        }
        return instance;
    }

    @Override
    public void registerStart(TestRunStartDescriptor tr) {
        this.registrationListenerRegistry.forEach(listener -> listener.onBeforeTestRunStart(tr));
        TestRunDTO testRun = TestRunDTO.builder().uuid(RunContextHolder.getTestRunUuid()).name(ConfigurationHolder.getRunDisplayNameOr(tr.getName())).framework(tr.getFramework()).startedAt(tr.getStartedAt()).config(new TestRunDTO.Config(ConfigurationHolder.getRunEnvironment(), ConfigurationHolder.getRunBuild(), ConfigurationHolder.shouldTreatSkipsAsFailures())).jenkinsContext(new TestRunDTO.JenkinsContext(System.getProperty("ci_url"), this.getIntegerSystemProperty("ci_build"), System.getProperty("ci_parent_url"), this.getIntegerSystemProperty("ci_parent_build"))).ciContext(this.ciContextResolver.resolve()).milestone(new TestRunDTO.Milestone(ConfigurationHolder.getMilestoneId(), ConfigurationHolder.getMilestoneName())).notifications(new TestRunDTO.Notifications(ConfigurationHolder.notificationsEnabled(), this.collectNotificationTargets(), ConfigurationHolder.shouldNotifyOnEachFailure())).build();
        testRun = this.apiClient.registerTestRunStart(testRun);
        if (testRun != null) {
            TestRunDescriptor testRunDescriptor = TestRunDescriptor.create(testRun.getId(), tr);
            RunContext.setRun(testRunDescriptor);
            this.logTestRunWarnings(testRun);
            this.saveRunLocaleFromProgramArguments();
            this.registrationListenerRegistry.forEach(listener -> listener.onAfterTestRunStart(tr));
        }
    }

    private void logTestRunWarnings(TestRunDTO testRun) {
        TestRunDTO.Metadata metadata = testRun.getMetadata();
        if (metadata != null) {
            String testRunName = testRun.getName();
            metadata.getWarningMessages().forEach(warning -> log.warn(TEST_RUN_WARNING_MSG_FORMAT, (Object)testRunName, warning));
        }
    }

    private Integer getIntegerSystemProperty(String propertyName) {
        return Optional.ofNullable(System.getProperty(propertyName)).filter(parentBuild -> !parentBuild.isEmpty()).map(Integer::parseInt).orElse(null);
    }

    private void saveRunLocaleFromProgramArguments() {
        String locale = System.getProperty("locale");
        if (locale != null) {
            Label.attachToTestRun("com.zebrunner.app/sut.locale", locale);
        }
    }

    private Set<NotificationTargetDTO> collectNotificationTargets() {
        String emailRecipients;
        String msTeamsChannels;
        HashSet<NotificationTargetDTO> notificationTargets = new HashSet<NotificationTargetDTO>();
        String slackChannels = ConfigurationHolder.getSlackChannels();
        if (slackChannels != null && !slackChannels.isEmpty()) {
            notificationTargets.add(new NotificationTargetDTO(NotificationTargetDTO.Type.SLACK_CHANNELS, slackChannels));
        }
        if ((msTeamsChannels = ConfigurationHolder.getMsTeamsChannels()) != null && !msTeamsChannels.isEmpty()) {
            notificationTargets.add(new NotificationTargetDTO(NotificationTargetDTO.Type.MS_TEAMS_CHANNELS, msTeamsChannels));
        }
        if ((emailRecipients = ConfigurationHolder.getEmails()) != null && !emailRecipients.isEmpty()) {
            notificationTargets.add(new NotificationTargetDTO(NotificationTargetDTO.Type.EMAIL_RECIPIENTS, emailRecipients));
        }
        return notificationTargets;
    }

    @Override
    public void registerFinish(TestRunFinishDescriptor finishDescriptor) {
        TestRunDTO testRun = TestRunDTO.builder().id(RunContext.getZebrunnerRunId()).endedAt(finishDescriptor.getEndedAt()).build();
        this.apiClient.registerTestRunFinish(testRun);
        TestRunDescriptor run = RunContext.getRun();
        if (run != null) {
            run.complete(finishDescriptor);
        }
    }

    @Override
    public void registerHeadlessTestStart(String id, TestStartDescriptor ts) {
        if (!RunContext.getCurrentTest().isPresent()) {
            TestDTO test = TestDTO.builder().name(ts.getName()).startedAt(ts.getStartedAt()).build();
            Long zebrunnerRunId = RunContext.getZebrunnerRunId();
            test = ts.getZebrunnerId() != null ? this.apiClient.registerTestRerunStart(zebrunnerRunId, ts.getZebrunnerId(), test, true) : this.apiClient.registerTestStart(zebrunnerRunId, test, true);
            if (test != null) {
                TestDescriptor testDescriptor = TestDescriptor.create(test.getId(), ts);
                RunContext.addCurrentTest(id, testDescriptor);
                this.testSessionRegistrar.linkAllCurrentToTest(test.getId());
            }
        }
    }

    @Override
    public void registerTestStart(String id, TestStartDescriptor ts) {
        this.registrationListenerRegistry.forEach(listener -> listener.onBeforeTestStart(ts));
        TestDTO test = TestDTO.builder().correlationData(ts.getCorrelationData()).name(ts.getName()).className(ts.getTestClass().getName()).methodName(ts.getTestMethod().getName()).argumentsIndex(ts.getArgumentsIndex()).maintainer(this.maintainerResolver.resolve(ts.getTestClass(), ts.getTestMethod())).startedAt(ts.getStartedAt()).labels(this.labelResolver.resolve(ts.getTestClass(), ts.getTestMethod())).testGroups(ts.getTestGroups()).build();
        Long headlessTestId = RunContext.getCurrentTest().map(TestDescriptor::getZebrunnerId).orElse(null);
        if (headlessTestId != null) {
            test.setId(headlessTestId);
            test = this.apiClient.registerHeadlessTestUpdate(RunContext.getZebrunnerRunId(), test);
        } else {
            test = ts.getZebrunnerId() != null ? this.apiClient.registerTestRerunStart(RunContext.getZebrunnerRunId(), ts.getZebrunnerId(), test, false) : this.apiClient.registerTestStart(RunContext.getZebrunnerRunId(), test, false);
        }
        if (test != null) {
            TestDescriptor testDescriptor = TestDescriptor.create(test.getId(), ts);
            RunContext.addCurrentTest(id, testDescriptor);
            this.testSessionRegistrar.linkAllCurrentToTest(test.getId());
            this.registrationListenerRegistry.forEach(listener -> listener.onAfterTestStart(ts));
        }
    }

    @Override
    public boolean isTestStarted() {
        return RunContext.getCurrentTest().isPresent();
    }

    @Override
    public boolean isTestStarted(String id) {
        return RunContext.getTest(id) != null;
    }

    @Override
    public void registerTestFinish(String id, TestFinishDescriptor tf) {
        TestDescriptor test = RunContext.getTest(id);
        if (test != null) {
            this.registrationListenerRegistry.forEach(listener -> listener.onBeforeTestFinish(tf));
            TestDTO result = TestDTO.builder().id(test.getZebrunnerId()).result(tf.getStatus().name()).reason(tf.getStatusReason()).endedAt(tf.getEndedAt()).build();
            this.apiClient.registerTestFinish(RunContext.getZebrunnerRunId(), result);
            this.registrationListenerRegistry.forEach(listener -> listener.onAfterTestFinish(tf));
            RunContext.completeTest(id, tf);
        }
    }

    @Override
    public void registerAfterTestStart() {
        RunContext.startAfterMethod();
    }

    @Override
    public void registerAfterTestFinish() {
        RunContext.finishAfterMethod();
    }

    @Override
    public boolean isKnownIssueAttachedToTest(String failureStacktrace) {
        Long runId = RunContext.getZebrunnerRunId();
        Optional<Long> maybeTestId = RunContext.getCurrentTest().map(TestDescriptor::getZebrunnerId);
        if (maybeTestId.isPresent()) {
            Long testId = maybeTestId.get();
            return this.apiClient.isKnownIssueAttachedToTest(runId, testId, failureStacktrace);
        }
        log.error("Failed to retrieve assigned known issues for stacktrace '{}' because test has not been started yet.", (Object)failureStacktrace);
        return false;
    }
}

