/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.registrar;

import com.zebrunner.agent.core.registrar.ClientRegistrar;
import com.zebrunner.agent.core.registrar.RunContextHolder;
import com.zebrunner.agent.core.registrar.ZebrunnerApiClient;
import com.zebrunner.agent.core.registrar.domain.ExchangeRunContextResponse;
import com.zebrunner.agent.core.registrar.domain.TestDTO;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RerunService {
    private static final Logger log = LoggerFactory.getLogger(RerunService.class);
    private static volatile List<TestDTO> fullExecutionContextTests;

    public static synchronized List<TestDTO> retrieveFullExecutionContextTests() {
        if (fullExecutionContextTests != null) {
            return fullExecutionContextTests;
        }
        String fullExecutionPlanContext = RunContextHolder.getFullExecutionPlanContext();
        if (fullExecutionPlanContext == null || !RunContextHolder.isRerun()) {
            log.debug("Full execution plan context is missing or rerun is not yet started.");
            return Collections.emptyList();
        }
        ZebrunnerApiClient apiClient = ClientRegistrar.getClient();
        ExchangeRunContextResponse response = apiClient.exchangeRerunCondition(fullExecutionPlanContext);
        List<TestDTO> tests = response.getTests();
        fullExecutionContextTests = tests;
        return tests;
    }
}

