/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.registrar;

import com.zebrunner.agent.core.registrar.ClientRegistrar;
import com.zebrunner.agent.core.registrar.RunContext;
import com.zebrunner.agent.core.registrar.TestSessionRegistrar;
import com.zebrunner.agent.core.registrar.ZebrunnerApiClient;
import com.zebrunner.agent.core.registrar.descriptor.SessionCloseDescriptor;
import com.zebrunner.agent.core.registrar.descriptor.SessionStartDescriptor;
import com.zebrunner.agent.core.registrar.descriptor.TestDescriptor;
import com.zebrunner.agent.core.registrar.domain.TestSessionDTO;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionRegistrar
implements TestSessionRegistrar {
    private static final Logger log = LoggerFactory.getLogger(SessionRegistrar.class);
    private static final SessionRegistrar INSTANCE = new SessionRegistrar();
    private final ZebrunnerApiClient apiClient = ClientRegistrar.getClient();
    private final Map<String, TestSessionDTO> sessionIdToSession = new ConcurrentHashMap<String, TestSessionDTO>();
    private final ThreadLocal<Set<String>> threadSessionIds = InheritableThreadLocal.withInitial(HashSet::new);

    SessionRegistrar() {
    }

    public static SessionRegistrar getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerStart(SessionStartDescriptor startDescriptor) {
        log.debug("Registering test session start. {}", (Object)startDescriptor);
        TestSessionDTO testSession = TestSessionDTO.builder().sessionId(startDescriptor.getSessionId()).initiatedAt(startDescriptor.getInitiatedAt()).startedAt(startDescriptor.getStartedAt()).status(startDescriptor.getStatus()).capabilities(startDescriptor.getCapabilities()).failureReason(startDescriptor.getFailureReason()).desiredCapabilities(startDescriptor.getDesiredCapabilities()).build();
        RunContext.getCurrentTest().map(TestDescriptor::getZebrunnerId).ifPresent(testSession.getTestIds()::add);
        testSession = this.apiClient.startSession(RunContext.getZebrunnerRunId(), testSession);
        if (testSession != null && testSession.getStatus() != TestSessionDTO.Status.FAILED) {
            this.sessionIdToSession.put(testSession.getSessionId(), testSession);
            this.threadSessionIds.get().add(testSession.getSessionId());
        }
        log.debug("Registration of test session start completed. {}", (Object)startDescriptor);
    }

    @Override
    public void registerClose(SessionCloseDescriptor closeDescriptor) {
        log.debug("Registering test session close. {}", (Object)closeDescriptor);
        TestSessionDTO testSession = this.sessionIdToSession.get(closeDescriptor.getSessionId());
        if (testSession != null) {
            testSession.setEndedAt(closeDescriptor.getEndedAt());
            this.apiClient.updateSession(RunContext.getZebrunnerRunId(), testSession);
            this.sessionIdToSession.remove(closeDescriptor.getSessionId());
            this.threadSessionIds.get().remove(closeDescriptor.getSessionId());
        }
        log.debug("Registration of test session close completed. {}", (Object)closeDescriptor);
    }

    @Override
    public void linkAllCurrentToTest(Long zebrunnerTestId) {
        this.threadSessionIds.get().forEach(sessionId -> this.link((String)sessionId, zebrunnerTestId));
    }

    @Override
    public void linkToCurrentTest(String sessionId) {
        RunContext.getCurrentTest().map(TestDescriptor::getZebrunnerId).ifPresent(currentTestId -> this.link(sessionId, (Long)currentTestId));
    }

    private void link(String sessionId, Long zebrunnerId) {
        Set<Long> testIds;
        TestSessionDTO testSession = this.sessionIdToSession.get(sessionId);
        if (testSession != null && (testIds = testSession.getTestIds()).add(zebrunnerId)) {
            log.debug("Linking test '{}' to session '{}'", (Object)zebrunnerId, (Object)sessionId);
            this.apiClient.updateSession(RunContext.getZebrunnerRunId(), testSession);
        }
    }
}

