/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.core.registrar;

import com.zebrunner.agent.core.registrar.Label;
import com.zebrunner.agent.core.registrar.TestCasesRegistry;
import com.zebrunner.agent.core.registrar.domain.TcmType;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestRail {
    private static final Logger log = LoggerFactory.getLogger(TestRail.class);
    public static final String SYNC_ENABLED = "com.zebrunner.app/tcm.testrail.sync.enabled";
    public static final String SYNC_REAL_TIME = "com.zebrunner.app/tcm.testrail.sync.real-time";
    public static final String INCLUDE_ALL = "com.zebrunner.app/tcm.testrail.include-all-cases";
    public static final String SUITE_ID = "com.zebrunner.app/tcm.testrail.suite-id";
    public static final String RUN_ID = "com.zebrunner.app/tcm.testrail.run-id";
    public static final String RUN_NAME = "com.zebrunner.app/tcm.testrail.run-name";
    public static final String MILESTONE = "com.zebrunner.app/tcm.testrail.milestone";
    public static final String ASSIGNEE = "com.zebrunner.app/tcm.testrail.assignee";
    private static final TestCasesRegistry TEST_CASES_REGISTRY = TestCasesRegistry.getInstance();
    private static volatile boolean isRealTimeSyncEnabled = false;

    public static void disableSync() {
        TestRail.attachLabelToTestRun(SYNC_ENABLED, "false");
    }

    public static synchronized void enableRealTimeSync() {
        if (!isRealTimeSyncEnabled) {
            TestRail.attachLabelToTestRun(SYNC_REAL_TIME, "true");
            TestRail.attachLabelToTestRun(INCLUDE_ALL, "true");
            isRealTimeSyncEnabled = true;
            log.warn("Runtime upload is enabled, all cases will be included in new run by default");
        } else {
            log.warn("Realtime sync for TestRail already enabled.");
        }
    }

    public static void includeAllTestCasesInNewRun() {
        TestRail.attachLabelToTestRun(INCLUDE_ALL, "true");
    }

    public static void setSuiteId(String suiteId) {
        TestRail.attachLabelToTestRun(SUITE_ID, suiteId);
    }

    public static void setRunId(String runId) {
        TestRail.attachLabelToTestRun(RUN_ID, runId);
    }

    public static void setRunName(String runName) {
        TestRail.attachLabelToTestRun(RUN_NAME, runName);
    }

    public static void setMilestone(String milestone) {
        TestRail.attachLabelToTestRun(MILESTONE, milestone);
    }

    public static void setAssignee(String assignee) {
        TestRail.attachLabelToTestRun(ASSIGNEE, assignee);
    }

    private static void attachLabelToTestRun(String name, String ... values) {
        if (isRealTimeSyncEnabled) {
            log.warn("Realtime sync for TestRail has been enabled, so you cannot overwrite TestRail configuration");
        } else {
            Label.attachToTestRun(name, values);
        }
    }

    @Deprecated
    public static void setCaseId(String testCaseId) {
        TestRail.setTestCaseId(testCaseId);
    }

    public static void setTestCaseId(String testCaseId) {
        TEST_CASES_REGISTRY.addTestCasesToCurrentTest(TcmType.TEST_RAIL, Collections.singleton(testCaseId));
    }

    public static void setTestCaseStatus(String testCaseId, String resultStatus) {
        TEST_CASES_REGISTRY.setCurrentTestTestCaseStatus(TcmType.TEST_RAIL, testCaseId, resultStatus);
    }

    private TestRail() {
    }

    public static class SystemTestCaseStatus {
        public static final String PASSED = "passed";
        public static final String BLOCKED = "blocked";
        public static final String RETEST = "retest";
        public static final String FAILED = "failed";

        private SystemTestCaseStatus() {
        }
    }
}

