/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.testng.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class TestMethodContext {
    private final ThreadLocal<AtomicInteger> currentInvocationCount = ThreadLocal.withInitial(() -> new AtomicInteger(0));
    private List<Integer> dataProviderIndicesForRerun = Collections.emptyList();
    private List<Object[]> dataProviderData = Collections.emptyList();
    private final ThreadLocal<Integer> currentDataProviderIteratorIndex = ThreadLocal.withInitial(() -> -1);

    public void setDataProviderIndicesForRerun(Collection<Integer> indicesForRerun) {
        this.dataProviderIndicesForRerun = new ArrayList<Integer>(indicesForRerun);
        Collections.sort(this.dataProviderIndicesForRerun);
    }

    public int getDataProviderSize() {
        return this.dataProviderData.size();
    }

    public void setDataProviderData(List<Object[]> dataProviderData) {
        if (dataProviderData != null) {
            this.dataProviderData = dataProviderData;
        }
    }

    public void setCurrentDataProviderIteratorIndex(int currentDataProviderIteratorIndex) {
        this.currentDataProviderIteratorIndex.set(currentDataProviderIteratorIndex);
    }

    public int getCurrentDataProviderIndex(Object[] actualTestParameters) {
        return this.getCurrentDataProviderIteratorIndex().filter(currentIndex -> currentIndex != -1).orElseGet(() -> this.getReferenceEqualDataProviderData(actualTestParameters).orElseGet(() -> this.getValueEqualDataProviderData(actualTestParameters).orElse(-1)));
    }

    public Optional<Integer> getCurrentDataProviderIteratorIndex() {
        Integer currentIndex = this.currentDataProviderIteratorIndex.get();
        if (currentIndex > -1 && this.dataProviderIndicesForRerun.size() > currentIndex) {
            return Optional.ofNullable(this.dataProviderIndicesForRerun.get(currentIndex));
        }
        return Optional.of(currentIndex);
    }

    public Optional<Integer> getReferenceEqualDataProviderData(Object[] data) {
        for (int i = 0; i < this.dataProviderData.size(); ++i) {
            if (this.dataProviderData.get(i) != data) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public Optional<Integer> getValueEqualDataProviderData(Object[] data) {
        List<Object> dataAsList = Arrays.asList(data);
        for (int i = 0; i < this.dataProviderData.size(); ++i) {
            List<Object> dataProviderLineAsList = Arrays.asList(this.dataProviderData.get(i));
            if (!dataProviderLineAsList.equals(dataAsList)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public void incrementInvocationIndex() {
        this.currentInvocationCount.get().incrementAndGet();
    }

    public int getCurrentInvocationIndex() {
        return this.currentInvocationCount.get().get();
    }

    public List<Integer> getDataProviderIndicesForRerun() {
        return this.dataProviderIndicesForRerun;
    }
}

