/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.testng.core.retry;

import com.zebrunner.agent.core.config.ConfigurationHolder;
import com.zebrunner.agent.core.registrar.TestRunRegistrar;
import com.zebrunner.agent.testng.core.ExceptionUtils;
import com.zebrunner.agent.testng.listener.RetryService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IRetryAnalyzer;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.InstanceCreator;

public class RetryAnalyzerInterceptor
implements IRetryAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(RetryAnalyzerInterceptor.class);
    private static final Map<String, IRetryAnalyzer> RETRY_ANALYZER_KEY_TO_IDENTITY = new ConcurrentHashMap<String, IRetryAnalyzer>();
    private final TestRunRegistrar registrar = TestRunRegistrar.getInstance();

    public boolean retry(ITestResult result) {
        ITestNGMethod method = result.getMethod();
        ITestContext context = result.getTestContext();
        IRetryAnalyzer retryAnalyzer = this.getOriginalRetryAnalyzer(result);
        boolean needRetry = retryAnalyzer.retry(result);
        if (needRetry && !ConfigurationHolder.shouldRetryKnownIssues()) {
            String stacktrace = ExceptionUtils.getStacktrace(result.getThrowable());
            if (this.registrar.isKnownIssueAttachedToTest(stacktrace)) {
                log.info("Known issue is attached to test for current failure stacktrace. Hence skipping retry logic");
                needRetry = false;
            } else {
                log.debug("No known issues are attached");
            }
        } else {
            log.debug("Feature with not retrying known issues is disabled");
        }
        if (needRetry) {
            RetryService.setRetryStarted(method, context);
        } else {
            RetryService.setRetryFinished(method, context);
        }
        return needRetry;
    }

    private IRetryAnalyzer getOriginalRetryAnalyzer(ITestResult result) {
        return RETRY_ANALYZER_KEY_TO_IDENTITY.computeIfAbsent(RetryService.buildRetryAnalyzerClassKey(result), $ -> RetryService.getRetryAnalyzerClass(result.getTestContext(), result.getMethod()).map(InstanceCreator::newInstance).orElseThrow(() -> new RuntimeException("There are no retry analyzer to apply.")));
    }
}

