/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.testng.core.testname;

import com.zebrunner.agent.testng.core.testname.TestNameResolver;
import com.zebrunner.agent.testng.listener.RunContextService;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.annotations.Test;

public class DefaultTestNameResolver
implements TestNameResolver {
    private final ConcurrentHashMap<String, AtomicInteger> testNameToInvCounter = new ConcurrentHashMap();

    @Override
    public String resolve(ITestResult testResult) {
        String testName = this.getMethodName(testResult);
        testName = this.appendDataProviderLine(testResult, testName);
        testName = this.appendInvocationCount(testResult, testName);
        return testName;
    }

    private String appendDataProviderLine(ITestResult testResult, String testName) {
        ITestNGMethod testMethod = testResult.getMethod();
        ITestContext testContext = testResult.getTestContext();
        Object[] parameters = testResult.getParameters();
        int dataProviderSize = RunContextService.getDataProviderSize(testMethod, testContext);
        if (dataProviderSize > 0) {
            int indexMaxLength = Integer.toString(dataProviderSize).length() + 1;
            String lineFormat = " [L%0" + indexMaxLength + "d]";
            int index = RunContextService.getCurrentDataProviderIndex(testMethod, testContext, parameters) + 1;
            testName = testName + String.format(lineFormat, index);
        }
        return testName;
    }

    private String appendInvocationCount(ITestResult testResult, String testName) {
        int expectedInvocationCount = this.getInvocationCount(testResult);
        if (expectedInvocationCount > 1) {
            int indexMaxLength = Integer.toString(expectedInvocationCount).length() + 1;
            String lineFormat = " [InvCount=%0" + indexMaxLength + "d]";
            int currentInvocationCount = this.testNameToInvCounter.computeIfAbsent(testName, $ -> new AtomicInteger(0)).incrementAndGet();
            testName = testName + String.format(lineFormat, currentInvocationCount);
        }
        return testName;
    }

    private int getInvocationCount(ITestResult testResult) {
        ITestNGMethod[] methods = testResult.getTestContext().getAllTestMethods();
        return Arrays.stream(methods).filter(method -> method.equals(testResult.getMethod())).findFirst().map(ITestNGMethod::getInvocationCount).orElse(0);
    }

    private String getMethodName(ITestResult testResult) {
        ITestNGMethod method = testResult.getMethod();
        Test testAnnotation = method.getConstructorOrMethod().getMethod().getAnnotation(Test.class);
        return Optional.ofNullable(testAnnotation).map(Test::testName).filter(testName -> !testName.trim().isEmpty()).orElseGet(() -> ((ITestNGMethod)method).getMethodName());
    }
}

