/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.testng.listener;

import com.google.common.collect.Lists;
import com.zebrunner.agent.core.registrar.RerunContextHolder;
import com.zebrunner.agent.testng.listener.RetryService;
import com.zebrunner.agent.testng.listener.RunContextService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.testng.IDataProviderInterceptor;
import org.testng.IDataProviderMethod;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;

public class DataProviderInterceptor
implements IDataProviderInterceptor {
    public Iterator<Object[]> intercept(Iterator<Object[]> original, IDataProviderMethod dataProviderMethod, ITestNGMethod method, ITestContext context) {
        List<Integer> indicesForRerun;
        if (original instanceof TrackableIterator) {
            return original;
        }
        List<Object> dataProviderData = Lists.newArrayList(original);
        RunContextService.setDataProviderData(method, context, dataProviderData);
        if (RerunContextHolder.isRerun() && !(indicesForRerun = RunContextService.getDataProviderIndicesForRerun(method, context)).isEmpty()) {
            dataProviderData = DataProviderInterceptor.filterDataProviderData(dataProviderData, indicesForRerun);
        }
        return new TrackableIterator(dataProviderData.iterator(), method, context);
    }

    private static List<Object[]> filterDataProviderData(List<Object[]> dataProviderData, List<Integer> indicesForRerun) {
        ArrayList<Object[]> filteredData = new ArrayList<Object[]>();
        for (Integer index : indicesForRerun) {
            if (index >= dataProviderData.size()) continue;
            filteredData.add(dataProviderData.get(index));
        }
        return filteredData;
    }

    private static class TrackableIterator
    implements Iterator<Object[]> {
        private final Iterator<Object[]> originalIterator;
        private final ITestNGMethod method;
        private final ITestContext context;
        private int index = 0;

        @Override
        public boolean hasNext() {
            return this.originalIterator.hasNext();
        }

        @Override
        public Object[] next() {
            if (RetryService.isRetryFinished(this.method, this.context)) {
                RunContextService.setCurrentDataProviderIteratorIndex(this.method, this.context, this.index++);
            }
            return this.originalIterator.next();
        }

        public TrackableIterator(Iterator<Object[]> originalIterator, ITestNGMethod method, ITestContext context) {
            this.originalIterator = originalIterator;
            this.method = method;
            this.context = context;
        }
    }
}

