/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.testng.listener;

import com.zebrunner.agent.core.listener.RerunListener;
import com.zebrunner.agent.core.registrar.RerunContextHolder;
import com.zebrunner.agent.core.registrar.domain.TestDTO;
import com.zebrunner.agent.testng.core.FactoryInstanceHolder;
import com.zebrunner.agent.testng.core.TestInvocationContext;
import com.zebrunner.agent.testng.core.retry.RetryAnalyzerInterceptor;
import com.zebrunner.agent.testng.listener.RetryService;
import com.zebrunner.agent.testng.listener.RunContextService;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.IRetryAnalyzer;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.TestRunner;

public class RerunAwareListener
implements RerunListener,
IMethodInterceptor {
    public void onRerun(List<TestDTO> tests) {
        Map<TestInvocationContext, Long> invocationContexts = this.getInvocationContexts(tests);
        RunContextService.setInvocationContextToTestIds(invocationContexts);
    }

    private Map<TestInvocationContext, Long> getInvocationContexts(List<TestDTO> testDTOs) {
        return testDTOs.stream().collect(Collectors.toMap(test -> TestInvocationContext.fromJsonString(test.getCorrelationData()), TestDTO::getId, (testId1, testId2) -> testId1));
    }

    public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
        TestRunner runner = (TestRunner)context;
        FactoryInstanceHolder.registerInstances(runner.getTestClasses());
        if (!methods.isEmpty()) {
            HashSet<IMethodInstance> methodsToSkipOnRerun = new HashSet<IMethodInstance>();
            HashSet<String> dependantMethods = new HashSet<String>();
            HashSet<String> dependantGroups = new HashSet<String>();
            for (IMethodInstance methodInstance : methods) {
                ITestNGMethod method = methodInstance.getMethod();
                Class retryAnalyser = method.getRetryAnalyzerClass();
                this.addRetryInterceptor(context, method, retryAnalyser);
                if (!RerunContextHolder.isRerun()) continue;
                List<TestInvocationContext> invocationsForRerun = RunContextService.findInvocationsForRerun(method);
                if (!invocationsForRerun.isEmpty()) {
                    Set<String> dependUponMethodsFromItem = this.collectDependantMethods(method);
                    Set<String> dependUponGroupsFromItem = this.collectDependantGroups(method);
                    dependantMethods.addAll(dependUponMethodsFromItem);
                    dependantGroups.addAll(dependUponGroupsFromItem);
                    this.collectDataProvidersForRerun(invocationsForRerun, method, (ITestContext)runner);
                    continue;
                }
                methodsToSkipOnRerun.add(methodInstance);
            }
            this.resolveDependantMethods(methods, dependantMethods, dependantGroups, methodsToSkipOnRerun);
            methods.removeAll(methodsToSkipOnRerun);
        }
        return methods;
    }

    private void addRetryInterceptor(ITestContext context, ITestNGMethod method, Class<? extends IRetryAnalyzer> retryAnalyser) {
        if (retryAnalyser != null && !retryAnalyser.isAssignableFrom(RetryAnalyzerInterceptor.class)) {
            RetryService.setRetryAnalyzerClass(retryAnalyser, context, method);
            method.setRetryAnalyzerClass(RetryAnalyzerInterceptor.class);
        }
    }

    private void resolveDependantMethods(List<IMethodInstance> methods, Set<String> dependantMethods, Set<String> dependantGroups, Set<IMethodInstance> methodsToSkipOnRerun) {
        for (IMethodInstance methodInstance : methods) {
            ITestNGMethod method = methodInstance.getMethod();
            boolean isMethodDependingUpon = this.isMethodDependingUpon(dependantMethods, method);
            boolean isGroupDependingUpon = this.isGroupDependingUpon(dependantGroups, method);
            if (!isMethodDependingUpon && !isGroupDependingUpon) continue;
            methodsToSkipOnRerun.remove(methodInstance);
            if (isMethodDependingUpon) {
                String dependsUponMethodKey = this.buildDependsUponMethodKey(method);
                dependantMethods.remove(dependsUponMethodKey);
                Set<String> dependUponMethodsFromItem = this.collectDependantMethods(method);
                dependantMethods.addAll(dependUponMethodsFromItem);
            }
            if (!isGroupDependingUpon) continue;
            this.filterDependantGroups(dependantGroups, method).forEach(dependantGroups::remove);
            Set<String> dependUponGroupsFromItem = this.collectDependantGroups(method);
            dependantGroups.addAll(dependUponGroupsFromItem);
        }
    }

    private boolean isMethodDependingUpon(Set<String> dependUponMethods, ITestNGMethod method) {
        String dependsUponMethodKey = this.buildDependsUponMethodKey(method);
        return dependUponMethods.contains(dependsUponMethodKey);
    }

    private boolean isGroupDependingUpon(Set<String> dependUponGroups, ITestNGMethod method) {
        return this.filterDependantGroups(dependUponGroups, method).findFirst().isPresent();
    }

    private Stream<String> filterDependantGroups(Set<String> dependantGroups, ITestNGMethod method) {
        return Arrays.stream(method.getGroups()).map(groupName -> this.buildDependsUponGroupKey((String)groupName, method)).filter(dependantGroups::contains);
    }

    private String buildDependsUponMethodKey(ITestNGMethod method) {
        String methodPath = method.getTestClass().getName() + "." + method.getMethodName();
        int instanceIndex = FactoryInstanceHolder.getInstanceIndex(method);
        return this.buildDependsUponKey(methodPath, instanceIndex);
    }

    private String buildDependsUponGroupKey(String groupName, ITestNGMethod method) {
        int instanceIndex = FactoryInstanceHolder.getInstanceIndex(method);
        return this.buildDependsUponKey(groupName, instanceIndex);
    }

    private Set<String> collectDependantMethods(ITestNGMethod method) {
        HashSet<String> dependantMethods = new HashSet<String>(Arrays.asList(method.getMethodsDependedUpon()));
        int instanceIndex = FactoryInstanceHolder.getInstanceIndex(method);
        return dependantMethods.stream().map(dependsUponMethod -> this.buildDependsUponKey((String)dependsUponMethod, instanceIndex)).collect(Collectors.toSet());
    }

    private Set<String> collectDependantGroups(ITestNGMethod method) {
        HashSet<String> dependantGroups = new HashSet<String>(Arrays.asList(method.getGroupsDependedUpon()));
        int instanceIndex = FactoryInstanceHolder.getInstanceIndex(method);
        return dependantGroups.stream().map(dependsUponGroup -> this.buildDependsUponKey((String)dependsUponGroup, instanceIndex)).collect(Collectors.toSet());
    }

    private String buildDependsUponKey(String name, long instanceHashCode) {
        return String.format("%d:%s", instanceHashCode, name);
    }

    private void collectDataProvidersForRerun(List<TestInvocationContext> invocationContexts, ITestNGMethod method, ITestContext context) {
        Set<Integer> indicesForRerun = invocationContexts.stream().map(TestInvocationContext::getDataProviderIndex).filter(index -> index != -1).collect(Collectors.toSet());
        RunContextService.setDataProviderIndicesForRerun(method, context, indicesForRerun);
    }
}

