/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.agent.testng.listener;

import com.zebrunner.agent.core.listener.RerunListener;
import com.zebrunner.agent.core.registrar.RerunService;
import com.zebrunner.agent.core.registrar.RunContextHolder;
import com.zebrunner.agent.core.registrar.domain.TestDTO;
import com.zebrunner.agent.testng.core.FactoryInstanceHolder;
import com.zebrunner.agent.testng.core.TestInvocationContext;
import com.zebrunner.agent.testng.core.method.DependantMethodResolver;
import com.zebrunner.agent.testng.core.retry.RetryAnalyzerInterceptor;
import com.zebrunner.agent.testng.listener.RetryService;
import com.zebrunner.agent.testng.listener.RunContextService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.TestRunner;

public class RerunAwareListener
implements RerunListener,
IMethodInterceptor {
    public void onRerun(List<TestDTO> tests) {
        Map<TestInvocationContext, Long> invocationContexts = this.getInvocationContexts(tests);
        RunContextService.addInvocationContexts(invocationContexts);
    }

    private Map<TestInvocationContext, Long> getInvocationContexts(List<TestDTO> testDTOs) {
        return testDTOs.stream().collect(Collectors.toMap(test -> TestInvocationContext.fromJsonString(test.getCorrelationData()), TestDTO::getId, (testId1, testId2) -> testId1));
    }

    public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
        TestRunner runner = (TestRunner)context;
        FactoryInstanceHolder.registerInstances(runner.getTestClasses());
        methods.forEach(methodInstance -> this.addRetryInterceptor(methodInstance.getMethod(), context));
        if (!RunContextHolder.isRerun()) {
            return methods;
        }
        Set<IMethodInstance> actualMethodsForRerun = this.getMethodsForRerun(methods);
        if (RunContextService.countInvocationContexts() < actualMethodsForRerun.size()) {
            List tests = RerunService.retrieveFullExecutionContextTests();
            Map<TestInvocationContext, Long> invocationContexts = this.getInvocationContexts(tests);
            RunContextService.addInvocationContexts(invocationContexts);
        }
        actualMethodsForRerun.forEach(methodInstance -> this.setDataProviderForRerun(methodInstance.getMethod(), (ITestContext)runner));
        return methods.stream().filter(actualMethodsForRerun::contains).collect(Collectors.toList());
    }

    private void addRetryInterceptor(ITestNGMethod method, ITestContext context) {
        Class retryAnalyser = method.getRetryAnalyzerClass();
        if (retryAnalyser != null && !retryAnalyser.isAssignableFrom(RetryAnalyzerInterceptor.class)) {
            RetryService.setRetryAnalyzerClass(retryAnalyser, context, method);
            method.setRetryAnalyzerClass(RetryAnalyzerInterceptor.class);
        }
    }

    private Set<IMethodInstance> getMethodsForRerun(List<IMethodInstance> methods) {
        Set<IMethodInstance> methodsForRerun = methods.stream().filter(instance -> RunContextService.isEligibleForRerun(instance.getMethod())).collect(Collectors.toSet());
        if (methodsForRerun.isEmpty()) {
            return Collections.emptySet();
        }
        Set<IMethodInstance> dependantMethods = DependantMethodResolver.resolve(methods, methodsForRerun);
        methodsForRerun.addAll(dependantMethods);
        return methodsForRerun;
    }

    private void setDataProviderForRerun(ITestNGMethod method, ITestContext context) {
        List<TestInvocationContext> invocationContexts = RunContextService.findInvocationsForRerun(method);
        Set<Integer> indicesForRerun = invocationContexts.stream().map(TestInvocationContext::getDataProviderIndex).filter(index -> index != -1).collect(Collectors.toSet());
        RunContextService.setDataProviderIndicesForRerun(method, context, indicesForRerun);
    }
}

