/*******************************************************************************
 * Copyright 2020-2022 Zebrunner Inc (https://www.zebrunner.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package com.zebrunner.carina.utils.android.recorder.utils;

/* 
 */

import java.util.Map;

import com.sun.jna.FromNativeContext;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIFunctionMapper;
import com.sun.jna.win32.W32APITypeMapper;

/**
 * Base type for most W32 API libraries. Provides standard options
 * for unicode/ASCII mappings. Set the system property w32.ascii
 * to true to default to the ASCII mappings.
 */

@SuppressWarnings({ "rawtypes", "serial", "unchecked" })
interface W32API extends StdCallLibrary {

    int NO_ERROR = 0;
    int ERROR_INVALID_FUNCTION = 1;
    int ERROR_FILE_NOT_FOUND = 2;
    int ERROR_PATH_NOT_FOUND = 3;

    /** Standard options to use the unicode version of a w32 API. */
    Map UNICODE_OPTIONS = Map.of(OPTION_TYPE_MAPPER, W32APITypeMapper.UNICODE, OPTION_FUNCTION_MAPPER, W32APIFunctionMapper.UNICODE);
    /** Standard options to use the ASCII/MBCS version of a w32 API. */
    Map ASCII_OPTIONS = Map.of(OPTION_TYPE_MAPPER, W32APITypeMapper.ASCII, OPTION_FUNCTION_MAPPER, W32APIFunctionMapper.ASCII);

    class HANDLE extends PointerType {
        @Override
        public Object fromNative(Object nativeValue, FromNativeContext context) {
            Object o = super.fromNative(nativeValue, context);
            if (INVALID_HANDLE_VALUE.equals(o))
                return INVALID_HANDLE_VALUE;
            return o;
        }
    }

    /** Constant value representing an invalid HANDLE. */
    HANDLE INVALID_HANDLE_VALUE = new HANDLE() {
        {
            super.setPointer(Pointer.createConstant(-1));
        }

        @Override
        public void setPointer(Pointer p) {
            throw new UnsupportedOperationException("Immutable reference");
        }
    };
}
