/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils;

import com.zebrunner.carina.utils.DefaultEnvArgResolver;
import com.zebrunner.carina.utils.IEnvArgResolver;
import com.zebrunner.carina.utils.R;
import com.zebrunner.carina.utils.exception.MissingParameterException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.openqa.selenium.MutableCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static IEnvArgResolver envArgResolver = new DefaultEnvArgResolver();

    public static String get(Parameter param) {
        String value = R.CONFIG.get(param.getKey());
        return value != null && !value.equalsIgnoreCase("NULL") ? value : "";
    }

    public static String getDecrypted(Parameter param) {
        String value = R.CONFIG.getDecrypted(param.getKey());
        return value != null && !value.equalsIgnoreCase("NULL") ? value : "";
    }

    public static int getInt(Parameter param) {
        return Integer.valueOf(Configuration.get(param).trim());
    }

    public static long getLong(Parameter param) {
        return Long.valueOf(Configuration.get(param).trim());
    }

    public static double getDouble(Parameter param) {
        return Double.valueOf(Configuration.get(param).trim());
    }

    public static boolean getBoolean(Parameter param) {
        String value = Configuration.get(param).trim();
        if (value == null || value.equalsIgnoreCase("NULL")) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public static String asString() {
        String lineFormat = "%s=%s%n";
        StringBuilder asString = new StringBuilder();
        asString.append("\n============= Test configuration =============\n");
        for (Parameter param : Parameter.values()) {
            if (Parameter.AZURE_BLOB_URL.equals((Object)param) && Configuration.get(param).toLowerCase().contains("NULL".toLowerCase()) || Parameter.CRYPTO_KEY_VALUE.equals((Object)param) || Configuration.get(param).isEmpty() || !R.CONFIG.isOverwritten(param.getKey())) continue;
            asString.append(String.format(lineFormat, param.getKey(), Configuration.get(param)));
        }
        asString.append(String.format(lineFormat, "selenium_url", Configuration.getSeleniumUrl()));
        asString.append("\n------------- Driver capabilities -----------\n");
        String prefix = "capabilities.";
        HashMap<Object, Object> capabilitiesMap = new HashMap<Object, Object>(R.CONFIG.getProperties());
        for (Map.Entry entry : capabilitiesMap.entrySet()) {
            if (!((String)entry.getKey()).toLowerCase().startsWith("capabilities.")) continue;
            asString.append(String.format(lineFormat, entry.getKey(), R.CONFIG.get((String)entry.getKey())));
        }
        asString.append("================================================\n");
        return asString.toString();
    }

    public static void validateConfiguration() {
        for (Parameter param : Parameter.values()) {
            if (!StringUtils.isEmpty((CharSequence)Configuration.get(param)) && !"{must_override}".equals(Configuration.get(param))) continue;
            throw new MissingParameterException("Configuration failure: parameter '" + param.getKey() + "' not specified!");
        }
    }

    public static String getEnvArg(String key) {
        return envArgResolver.get(Configuration.get(Parameter.ENV), key);
    }

    public static IEnvArgResolver getEnvArgResolver() {
        return envArgResolver;
    }

    public static boolean isNull(Parameter param) {
        return Configuration.get(param).isEmpty();
    }

    public static int getAdbExecTimeout() {
        int adbExecTimeout = 20000;
        if (!R.CONFIG.get("capabilities.adbExecTimeout").isEmpty()) {
            adbExecTimeout = R.CONFIG.getInt("capabilities.adbExecTimeout");
        }
        return adbExecTimeout;
    }

    public static String getPlatform() {
        String platform = "*";
        LOGGER.debug("platform1: {}", (Object)platform);
        if (!R.CONFIG.get("capabilities.os").isEmpty()) {
            platform = R.CONFIG.get("capabilities.os");
            LOGGER.debug("platform2: {}", (Object)platform);
        }
        if (!R.CONFIG.get("capabilities.platformName").isEmpty()) {
            platform = R.CONFIG.get("capabilities.platformName");
            LOGGER.debug("platform3: {}", (Object)platform);
        }
        return platform;
    }

    @Deprecated(forRemoval=true, since="8.0.2")
    public static String getPlatform(MutableCapabilities caps) {
        String platform = "*";
        LOGGER.debug("platform1: {}", (Object)platform);
        if (!R.CONFIG.get("capabilities.os").isEmpty()) {
            platform = R.CONFIG.get("capabilities.os");
        }
        LOGGER.debug("platform2: {}", (Object)platform);
        if (!R.CONFIG.get("capabilities.platformName").isEmpty()) {
            platform = R.CONFIG.get("capabilities.platformName");
        }
        LOGGER.debug("platform3: {}", (Object)platform);
        LOGGER.debug("platform4: {}", (Object)platform);
        return platform;
    }

    public static String getPlatformVersion() {
        return Configuration.getPlatformVersion(new MutableCapabilities());
    }

    public static String getPlatformVersion(MutableCapabilities caps) {
        String platformVersion = "";
        if (!R.CONFIG.get("capabilities.os_version").isEmpty()) {
            platformVersion = R.CONFIG.get("capabilities.os_version");
        }
        if (!R.CONFIG.get("capabilities.platformVersion").isEmpty()) {
            platformVersion = R.CONFIG.get("capabilities.platformVersion");
        }
        if (caps != null && caps.getCapability("os_version") != null) {
            platformVersion = caps.getCapability("os_version").toString();
        }
        if (caps != null && caps.getCapability("platformVersion") != null) {
            platformVersion = caps.getCapability("platformVersion").toString();
        }
        return platformVersion;
    }

    public static String getBrowser() {
        String configBrowserName;
        String browser = "";
        if (!Configuration.get(Parameter.BROWSER).isEmpty()) {
            browser = Configuration.get(Parameter.BROWSER);
        }
        if (!(configBrowserName = Configuration.getCapability("browserName")).isEmpty() && !"null".equalsIgnoreCase(configBrowserName)) {
            browser = configBrowserName;
        }
        return browser;
    }

    public static String getBrowserVersion() {
        String browserVersion = "";
        String configBrowserVersion = Configuration.getCapability("browserVersion");
        if (!configBrowserVersion.isEmpty() && !"null".equalsIgnoreCase(configBrowserVersion)) {
            browserVersion = configBrowserVersion;
        }
        return browserVersion;
    }

    public static String getDriverType() {
        String platform = Configuration.getPlatform();
        String browserName = Configuration.getBrowser();
        if (platform.equalsIgnoreCase("Android") || platform.equalsIgnoreCase("IOS") || platform.equalsIgnoreCase("TVOS")) {
            return "mobile";
        }
        if (!StringUtils.isEmpty((CharSequence)browserName)) {
            return "desktop";
        }
        if ("Windows".equalsIgnoreCase(platform)) {
            return "Windows";
        }
        if ("MAC".equalsIgnoreCase(platform)) {
            return "MAC";
        }
        return "desktop";
    }

    public static String getDriverType(MutableCapabilities capabilities) {
        if (capabilities == null) {
            return Configuration.getDriverType();
        }
        String platform = "";
        String browserName = Configuration.getBrowser();
        if (capabilities.getCapability("platformName") != null) {
            platform = capabilities.getCapability("platformName").toString();
        }
        if ("Android".equalsIgnoreCase(platform) || "IOS".equalsIgnoreCase(platform) || "TVOS".equalsIgnoreCase(platform)) {
            return "mobile";
        }
        if (!StringUtils.isEmpty((CharSequence)browserName)) {
            return "desktop";
        }
        if ("Windows".equalsIgnoreCase(platform)) {
            return "Windows";
        }
        if ("MAC".equalsIgnoreCase(platform)) {
            return "MAC";
        }
        if (capabilities.getCapability("udid") != null) {
            LOGGER.debug("Detected MOBILE driver_type by uuid inside capabilities");
            return "mobile";
        }
        return "desktop";
    }

    public static String getMobileApp() {
        String mobileApp = "";
        String prefix = "capabilities.";
        if (!R.CONFIG.get(prefix + "app").isEmpty()) {
            mobileApp = R.CONFIG.get(prefix + "app");
        }
        return mobileApp;
    }

    public static void setMobileApp(String mobileApp) {
        R.CONFIG.put("capabilities.app", mobileApp);
        LOGGER.info("Updated mobile app: {}", (Object)mobileApp);
    }

    public static String getCapability(String name) {
        return R.CONFIG.get("capabilities." + name);
    }

    public static void setBuild(String build) {
        R.CONFIG.put(Parameter.APP_VERSION.getKey(), build);
        if (!build.isEmpty()) {
            LOGGER.debug("build: {}", (Object)build);
            try {
                Class artifactClass = ClassUtils.getClass((String)"com.zebrunner.agent.core.registrar.CurrentTestRun");
                MethodUtils.invokeStaticMethod((Class)artifactClass, (String)"setBuild", (Object[])new Object[]{build});
            }
            catch (Exception e) {
                LOGGER.debug("Cannot attach build to the current test run.", (Throwable)e);
            }
        }
    }

    public static String getSeleniumUrl() {
        return Configuration.get(Parameter.SELENIUM_URL);
    }

    public static int getThreadCount() {
        return Configuration.getInt(Parameter.THREAD_COUNT);
    }

    public static int getDataProviderThreadCount() {
        return Configuration.getInt(Parameter.DATA_PROVIDER_THREAD_COUNT);
    }

    public static enum Parameter {
        URL("url"),
        ENV("env"),
        BROWSER("browser"),
        BROWSER_LANGUAGE("browser_language"),
        SELENIUM_URL("selenium_url"),
        DRIVER_EVENT_LISTENERS("driver_event_listeners"),
        MAX_DRIVER_COUNT("max_driver_count"),
        FORCIBLY_DISABLE_DRIVER_QUIT("forcibly_disable_driver_quit"),
        CUSTOM_CAPABILITIES("custom_capabilities"),
        CHROME_ARGS("chrome_args"),
        CHROME_EXPERIMENTAL_OPTS("chrome_experimental_opts"),
        CHROME_MOBILE_EMULATION_OPTS("chrome_mobile_emulation_opts"),
        CHROME_CLOSURE("chrome_closure"),
        FIREFOX_ARGS("firefox_args"),
        FIREFOX_PREFERENCES("firefox_preferences"),
        HEADLESS("headless"),
        APP_VERSION("app_version"),
        PROXY_HOST("proxy_host"),
        PROXY_PORT("proxy_port"),
        PROXY_PROTOCOLS("proxy_protocols"),
        NO_PROXY("no_proxy"),
        BROWSERUP_PROXY("browserup_proxy"),
        BROWSERUP_PORT("browserup_port"),
        BROWSERUP_PORTS_RANGE("browserup_ports_range"),
        BROWSERUP_MITM("browserup_disabled_mitm"),
        PROXY_SET_TO_SYSTEM("proxy_set_to_system"),
        REPORT_URL("report_url"),
        AUTO_SCREENSHOT("auto_screenshot"),
        ERROR_SCREENSHOT("error_screenshot"),
        ALLOW_FULLSIZE_SCREENSHOT("allow_fullsize_screenshot"),
        EXPLICIT_TIMEOUT("explicit_timeout"),
        AUTO_DOWNLOAD("auto_download"),
        AUTO_DOWNLOAD_APPS("auto_download_apps"),
        CUSTOM_ARTIFACTS_FOLDER("custom_artifacts_folder"),
        RETRY_INTERVAL("retry_interval"),
        PROJECT_REPORT_DIRECTORY("project_report_directory"),
        MAX_SCREENSHOOT_HISTORY("max_screen_history"),
        BIG_SCREEN_WIDTH("big_screen_width"),
        BIG_SCREEN_HEIGHT("big_screen_height"),
        INIT_RETRY_COUNT("init_retry_count"),
        INIT_RETRY_INTERVAL("init_retry_interval"),
        RETRY_COUNT("retry_count"),
        LOCALE("locale"),
        THREAD_COUNT("thread_count"),
        DATA_PROVIDER_THREAD_COUNT("data_provider_thread_count"),
        CORE_LOG_LEVEL("core_log_level"),
        LOG_ALL_JSON("log_all_json"),
        DATE_FORMAT("date_format"),
        TIME_FORMAT("time_format"),
        CRYPTO_KEY_VALUE("crypto_key_value"),
        CRYPTO_PATTERN("crypto_pattern"),
        CRYPTO_ALGORITHM("crypto_algorithm"),
        SUITE_NAME("suite_name"),
        TEST_NAMING_PATTERN("test_naming_pattern"),
        ELEMENT_LOADING_STRATEGY("element_loading_strategy"),
        PAGE_OPENING_STRATEGY("page_opening_strategy"),
        S3_BUCKET_NAME("s3_bucket_name"),
        S3_REGION("s3_region"),
        ACCESS_KEY_ID("access_key_id"),
        SECRET_KEY("secret_key"),
        AZURE_ACCOUNT_NAME("azure_account_name"),
        AZURE_CONTAINER_NAME("azure_container_name"),
        AZURE_BLOB_URL("azure_blob_url"),
        AZURE_ACCESS_KEY_TOKEN("azure_access_key_token"),
        AZURE_LOCAL_STORAGE("azure_local_storage"),
        APPCENTER_TOKEN("appcenter_token"),
        LOCALIZATION_ENCODING("localization_encoding"),
        LOCALIZATION_TESTING("localization_testing"),
        TLS_KEYSECURE_LOCATION("tls_keysecure_location"),
        UNINSTALL_RELATED_APPS("uninstall_related_apps"),
        DEFAULT_DEVICE_TIMEZONE("default_device_timezone"),
        DEFAULT_DEVICE_TIME_FORMAT("default_device_time_format"),
        DEFAULT_DEVICE_LANGUAGE("default_device_language"),
        IGNORE_SSL("ignore_ssl"),
        TEST_RUN_RULES("test_run_rules"),
        TESTRAIL_ENABLED("testrail_enabled"),
        INCLUDE_ALL("include_all"),
        MILESTONE("milestone"),
        RUN_NAME("run_name"),
        ASSIGNEE("assignee"),
        GIT_HASH("git_hash"),
        LANGUAGE("language"),
        W3C("w3c");

        private final String key;

        private Parameter(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

