/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.zebrunner.carina.utils.exception.JsonParseException;
import java.io.File;
import java.lang.reflect.Type;

public final class JsonUtils {
    private static final ObjectMapper mapper = new ObjectMapper();

    private JsonUtils() {
    }

    public static <T> T fromJson(String json, Class<T> classOfT) {
        try {
            return (T)mapper.readValue(json, classOfT);
        }
        catch (Exception e) {
            throw new JsonParseException(e.getMessage(), e);
        }
    }

    public static String toJson(Object src) {
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(src);
        }
        catch (Exception e) {
            throw new JsonParseException(e.getMessage(), e);
        }
    }

    public static <T> T fromJson(File file, Class<T> classOfT) {
        try {
            return (T)mapper.readValue(file, classOfT);
        }
        catch (Exception e) {
            throw new JsonParseException(e.getMessage(), e);
        }
    }

    public static <T> T fromJson(File file, Type type) {
        try {
            TypeFactory tf = mapper.getTypeFactory();
            JavaType javaType = tf.constructType(type);
            return (T)mapper.readValue(file, javaType);
        }
        catch (Exception e) {
            throw new JsonParseException(e.getMessage(), e);
        }
    }

    public static <T> T fromJson(String json, Type type) {
        try {
            TypeFactory tf = mapper.getTypeFactory();
            JavaType javaType = tf.constructType(type);
            return (T)mapper.readValue(json, javaType);
        }
        catch (Exception e) {
            throw new JsonParseException(e.getMessage(), e);
        }
    }

    public static JsonNode readTree(String content) {
        try {
            return mapper.readTree(content);
        }
        catch (Exception e) {
            throw new JsonParseException(e.getMessage(), e);
        }
    }

    public static <T> T treeToValue(JsonNode node, Class<? extends T> type) {
        try {
            return (T)mapper.treeToValue((TreeNode)node, type);
        }
        catch (Exception e) {
            throw new JsonParseException(e.getMessage(), e);
        }
    }
}

