/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils;

import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;

public final class LogicUtils {
    private static final Random random = new Random();

    private LogicUtils() {
    }

    public static boolean isURLEqual(String url1, String url2) {
        url1 = StringUtils.replace((String)url1, (String)"https://", (String)"http://");
        url2 = StringUtils.replace((String)url2, (String)"https://", (String)"http://");
        url1 = StringUtils.removeEnd((String)url1, (String)"/");
        url2 = StringUtils.removeEnd((String)url2, (String)"/");
        url1 = url1.contains("?") ? url1.substring(0, url1.indexOf(63)) : url1;
        String string = url2 = url2.contains("?") ? url2.substring(0, url2.indexOf(63)) : url2;
        if (url1.contains("$ignore") || url2.contains("$ignore")) {
            String[] urlAr1 = url1.split("/");
            String[] urlAr2 = url2.split("/");
            return LogicUtils.compareWithIgnore(urlAr1, urlAr2);
        }
        return url1.equals(url2);
    }

    public static boolean isAllTrue(boolean ... cases) {
        for (int i = 0; i < cases.length; ++i) {
            if (cases[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean compareWithIgnore(String[] urlAr1, String[] urlAr2) {
        int count = Math.min(urlAr1.length, urlAr2.length);
        for (int i = 0; i < count; ++i) {
            if (urlAr1.length - 1 <= i && "$ignore".equals(urlAr2[i]) || urlAr2.length - 1 <= i && "$ignore".equals(urlAr1[i]) || "$ignore".equals(urlAr1[i]) || "$ignore".equals(urlAr2[i]) || urlAr1[i].equalsIgnoreCase(urlAr2[i])) continue;
            return false;
        }
        return true;
    }

    public static int getRandomNumber(int max) {
        return max == 0 ? 0 : random.nextInt(max);
    }

    public static WebElement selectRandomElement(List<WebElement> elements) {
        return elements != null ? elements.get(LogicUtils.getRandomNumber(elements.size())) : null;
    }
}

