/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.io.RandomAccessBufferedFileInputStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;

public final class PDFUtil {
    private PDFUtil() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String readTxtFromPDF(InputStream inputStream, int startPage, int endPage) {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream argument cannot be null");
        }
        PDFTextStripper pdfStripper = null;
        PDFParser parser = null;
        try (InputStream inputStream2 = inputStream;
             RandomAccessBufferedFileInputStream randomAccessBufferedFileInputStream = new RandomAccessBufferedFileInputStream(inputStream);){
            parser = new PDFParser((RandomAccessRead)randomAccessBufferedFileInputStream);
            parser.parse();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try (COSDocument cosDoc = parser.getDocument();){
            String string;
            try (PDDocument pdDoc = new PDDocument(cosDoc);){
                pdfStripper = new PDFTextStripper();
                pdfStripper.setSortByPosition(true);
                pdfStripper.setStartPage(startPage);
                pdfStripper.setEndPage(endPage);
                string = pdfStripper.getText(pdDoc);
            }
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

