/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils.android;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.FluentWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToastDetector
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String TOAST_PATTERN = "//*[@text='%s']";
    private boolean isPresent = false;
    private int waitTimeout = 20;
    private WebDriver webDriver;
    private String toastToWait;

    public ToastDetector(WebDriver webDriver, String toastToWait) {
        this.webDriver = webDriver;
        this.toastToWait = toastToWait;
    }

    public void setToastToWait(String toastToWait) {
        this.toastToWait = toastToWait;
    }

    public void setWaitTimeout(int waitTimeout) {
        if (waitTimeout > 60) {
            LOGGER.warn("Max wait timeout 60 second!");
            this.waitTimeout = 60;
            return;
        }
        this.waitTimeout = waitTimeout;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    @Override
    public void run() {
        this.waitForToast();
    }

    private void waitForToast() {
        LOGGER.info("Wait for toast...");
        this.isPresent = false;
        FluentWait fluentWait = new FluentWait((Object)this.webDriver);
        fluentWait.withTimeout(Duration.ofSeconds(this.waitTimeout)).pollingEvery(Duration.ofMillis(300L)).until(input -> {
            List webElemenList = this.webDriver.findElements(By.xpath((String)String.format(TOAST_PATTERN, this.toastToWait)));
            if (webElemenList.size() == 1) {
                LOGGER.info("Toast with text present: {}", (Object)this.toastToWait);
                this.isPresent = true;
                return true;
            }
            return false;
        });
    }

    public void startFinding() {
        Thread thread = new Thread(this);
        try {
            thread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

