/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils.ftp;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Base64;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FtpUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int DEFAULT_PORT = 21;
    private static int uploading = 0;

    private FtpUtils() {
    }

    public static void uploadFile(String ftpHost, String user, String password, String filePassToUpload, String fileName) {
        FtpUtils.uploadFile(ftpHost, 21, user, password, filePassToUpload, fileName);
    }

    public static void uploadFile(String ftpHost, int port, String user, String password, String filePassToUpload, String fileName) {
        try (FileInputStream is = new FileInputStream(filePassToUpload);){
            FtpUtils.upload(ftpHost, port, user, password, is, fileName);
        }
        catch (FileNotFoundException e) {
            LOGGER.info("File is not found. Specify correct file pass");
        }
        catch (IOException e) {
            LOGGER.info("Exception while opening file for upload.");
        }
    }

    public static void uploadData(String ftpHost, String user, String password, String data, String destinationFileName) {
        FtpUtils.uploadData(ftpHost, 21, user, password, data, destinationFileName);
    }

    public static void uploadData(String ftpHost, int port, String user, String password, String data, String destinationFileName) {
        byte[] decode = Base64.getDecoder().decode(data);
        LOGGER.debug("Data size to upload: {}", (Object)data.length());
        LOGGER.debug("Encoded data size to upload: {}", (Object)decode.length);
        try (ByteArrayInputStream is = new ByteArrayInputStream(decode);){
            FtpUtils.upload(ftpHost, port, user, password, is, destinationFileName);
        }
        catch (IOException e) {
            LOGGER.info("Exception while opening file for upload.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void upload(String ftpHost, int port, String user, String password, InputStream is, String fileName) {
        LOGGER.debug("FTP host to upload data : {}", (Object)ftpHost);
        LOGGER.debug("FTP port to upload data : {}", (Object)port);
        LOGGER.debug("Destination file name : {}", (Object)fileName);
        long start = System.currentTimeMillis();
        FTPClient ftp = new FTPClient();
        try {
            ftp.connect(ftpHost, port);
            LOGGER.debug("Connected to server : {}", (Object)ftpHost);
            int reply = ftp.getReplyCode();
            LOGGER.debug("Reply code is : {}", (Object)reply);
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftp.disconnect();
                LOGGER.error("FTP server refused connection. Reply code is : {}", (Object)reply);
                throw new Exception("FTP server refused connection.");
            }
            if (!ftp.login(user, password)) {
                throw new Exception("Login to ftp failed. Check user credentials.");
            }
            LOGGER.debug("User has been successfully logged in.");
            ftp.setFileType(2);
            try {
                ftp.enterLocalPassiveMode();
                LOGGER.debug("Passive host : {} Passive port : {}", (Object)ftp.getPassiveHost(), (Object)ftp.getPassivePort());
                LOGGER.debug("Default port : {}", (Object)ftp.getDefaultPort());
                LOGGER.debug("Local port : {}", (Object)ftp.getLocalPort());
                LOGGER.debug("Remote port : {}", (Object)ftp.getRemotePort());
                ++uploading;
                LOGGER.info("Uploading video: {}", (Object)fileName);
                if (ftp.storeFile(fileName, is)) {
                    LOGGER.info("Uploaded video in {} msecs for: {}", (Object)(System.currentTimeMillis() - start), (Object)fileName);
                } else {
                    LOGGER.error("Failed to upload video in {} msecs for: {}", (Object)(System.currentTimeMillis() - start), (Object)fileName);
                }
            }
            catch (IOException e) {
                LOGGER.error("Exception while storing file to FTP", (Throwable)e);
            }
            finally {
                --uploading;
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while uploading while to FTP", (Throwable)e);
        }
        finally {
            FtpUtils.ftpDisconnect(ftp);
        }
    }

    public static void ftpDisconnect(FTPClient ftp) {
        try {
            if (ftp.isConnected()) {
                ftp.logout();
                ftp.disconnect();
                LOGGER.debug("FTP has been successfully disconnected.");
            }
        }
        catch (Exception ioe) {
            LOGGER.error("Exception while disconnecting ftp", (Throwable)ioe);
        }
    }

    public static boolean isUploading() {
        return uploading > 0;
    }
}

