/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils.messager;

import com.zebrunner.carina.utils.Configuration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.testng.Reporter;

public interface IMessager {
    public String getPattern();

    public Logger getLogger();

    default public String getMessage(String ... args) {
        return this.create(args);
    }

    default public String info(String ... args) {
        String message = this.create(args);
        this.getLogger().info(message);
        return message;
    }

    default public String error(String ... args) {
        String message = this.create(args);
        Reporter.log((String)message);
        this.getLogger().error(message);
        return message;
    }

    default public String warn(String ... args) {
        String message = this.create(args);
        Reporter.log((String)message);
        this.getLogger().warn(message);
        return message;
    }

    default public String create(String ... args) {
        Pattern cryptoPattern = Pattern.compile(Configuration.get(Configuration.Parameter.CRYPTO_PATTERN));
        String message = "";
        try {
            for (int i = 0; i < args.length; ++i) {
                Matcher matcher;
                if (args[i] == null || !(matcher = cryptoPattern.matcher(args[i])).find()) continue;
                int start = args[i].indexOf(58) + 1;
                int end = args[i].indexOf(125);
                args[i] = StringUtils.replace((String)args[i], (String)matcher.group(), (String)StringUtils.repeat((char)'*', (int)(end - start)));
            }
            message = String.format(this.getPattern(), args);
        }
        catch (Exception e) {
            this.getLogger().error("Report message creation error!", (Throwable)e);
        }
        return message;
    }
}

