/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils.mobile.notifications;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.zebrunner.carina.utils.rest.RestUtil;
import io.restassured.response.Response;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NotificationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PASSED_MESSAGE = "Call passed with status code '{}'. ";
    private static final String FAILED_MESSAGE = "Call failed with status code '{}'. ";
    private static final String REQUEST_URL_MESSAGE = "Request url: {}";

    private NotificationUtils() {
    }

    public static JsonObject callPushService(String contentType, Map<String, ?> parameters, String url) {
        return NotificationUtils.callPushService(contentType, parameters, url, true);
    }

    public static JsonObject callPushService(String contentType, Map<String, ?> parameters, String url, boolean responseLog) {
        try {
            LOGGER.info(REQUEST_URL_MESSAGE, (Object)url);
            Response response = RestUtil.sendHttpPost(contentType, parameters, url, responseLog);
            if (response.getStatusCode() == 200) {
                LOGGER.debug(PASSED_MESSAGE, (Object)response.getStatusCode());
                return JsonParser.parseString((String)response.asString()).getAsJsonObject();
            }
            LOGGER.error(FAILED_MESSAGE, (Object)response.getStatusCode());
        }
        catch (Exception e) {
            LOGGER.error("callPushService failure", (Throwable)e);
        }
        return null;
    }

    public static JsonObject getPushServiceResponse(String request, String url) {
        return NotificationUtils.getPushServiceResponse("application/json", request, url, true);
    }

    public static JsonObject getPushServiceResponse(String contentType, String request, String url, boolean responseLog) {
        try {
            LOGGER.info(REQUEST_URL_MESSAGE, (Object)url);
            Response response = RestUtil.sendHttpPost(contentType, request, url.toString(), responseLog);
            if (response.getStatusCode() == 200) {
                LOGGER.debug(PASSED_MESSAGE, (Object)response.getStatusCode());
                return JsonParser.parseString((String)response.asString()).getAsJsonObject();
            }
            LOGGER.error(FAILED_MESSAGE, (Object)response.getStatusCode());
        }
        catch (Exception e) {
            LOGGER.error("getPushServiceResponse failure", (Throwable)e);
        }
        return null;
    }

    public static JsonObject getGetServiceResponse(String url) {
        return NotificationUtils.getGetServiceResponse("application/json", url, true);
    }

    public static JsonObject getGetServiceResponse(String contentType, String url, boolean responseLog) {
        try {
            LOGGER.info(REQUEST_URL_MESSAGE, (Object)url);
            Response response = RestUtil.sendHttpGet(contentType, url, responseLog);
            if (response.getStatusCode() == 200) {
                LOGGER.debug(PASSED_MESSAGE, (Object)response.getStatusCode());
                return JsonParser.parseString((String)response.asString()).getAsJsonObject();
            }
            LOGGER.error(FAILED_MESSAGE, (Object)response.getStatusCode());
        }
        catch (Exception e) {
            LOGGER.error("getGetServiceResponse failure", (Throwable)e);
        }
        return null;
    }
}

