/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils.report;

import com.zebrunner.carina.utils.Configuration;
import com.zebrunner.carina.utils.FileManager;
import com.zebrunner.carina.utils.R;
import com.zebrunner.carina.utils.ZipManager;
import com.zebrunner.carina.utils.common.CommonUtils;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.imgscalr.Scalr;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.decorators.Decorated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;

public class ReportContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String ROOT_DIR_SYSTEM_PROPERTY = "user.dir";
    private static final String FOLDERS_FORMAT = "%s/%s";
    private static final String SPACE_PATTERN = "[^a-zA-Z0-9.-]";
    public static final String ARTIFACTS_FOLDER = "downloads";
    private static final String GALLERY_ZIP = "gallery-lib.zip";
    private static final String REPORT_NAME = "/report.html";
    private static final int MAX_IMAGE_TITLE = 300;
    private static final String TITLE = "Test steps demo";
    public static final String TEMP_FOLDER = "temp";
    private static File baseDirectory = null;
    private static File tempDirectory;
    private static long rootID;
    private static final ThreadLocal<File> testDirectory;
    private static final ThreadLocal<Boolean> isCustomTestDirName;
    private static final ExecutorService executor;
    private static final Map<String, String> screenSteps;

    private ReportContext() {
    }

    public static File getBaseDir() {
        if (baseDirectory == null) {
            boolean isCreated;
            ReportContext.removeOldReports();
            File projectRoot = new File(String.format(FOLDERS_FORMAT, URLDecoder.decode(System.getProperty(ROOT_DIR_SYSTEM_PROPERTY), StandardCharsets.UTF_8), Configuration.get(Configuration.Parameter.PROJECT_REPORT_DIRECTORY)));
            if (!projectRoot.exists() && !(isCreated = projectRoot.mkdirs())) {
                throw new RuntimeException("Folder not created: " + projectRoot.getAbsolutePath());
            }
            rootID = System.currentTimeMillis();
            String directory = String.format("%s/%s/%d", URLDecoder.decode(System.getProperty(ROOT_DIR_SYSTEM_PROPERTY), StandardCharsets.UTF_8), Configuration.get(Configuration.Parameter.PROJECT_REPORT_DIRECTORY), rootID);
            File baseDirectoryTmp = new File(directory);
            boolean isCreated2 = baseDirectoryTmp.mkdir();
            if (!isCreated2) {
                throw new RuntimeException("Folder not created: " + baseDirectory.getAbsolutePath());
            }
            baseDirectory = baseDirectoryTmp;
            ReportContext.copyGalleryLib();
        }
        return baseDirectory;
    }

    public static synchronized File getTempDir() {
        boolean isCreated;
        if (tempDirectory == null && !(isCreated = (tempDirectory = new File(String.format(FOLDERS_FORMAT, ReportContext.getBaseDir().getAbsolutePath(), TEMP_FOLDER))).mkdir())) {
            throw new RuntimeException("Folder not created: " + tempDirectory.getAbsolutePath());
        }
        return tempDirectory;
    }

    public static File getTestDir() {
        return ReportContext.getTestDir("");
    }

    private static File getTestDir(String dirName) {
        File testDir = testDirectory.get();
        if (testDir == null) {
            testDir = ReportContext.createTestDir(dirName);
        }
        return testDir;
    }

    public static synchronized File setCustomTestDirName(String dirName) {
        isCustomTestDirName.set(Boolean.FALSE);
        File testDir = testDirectory.get();
        if (testDir == null) {
            LOGGER.debug("Test dir will be created.");
            testDir = ReportContext.getTestDir(dirName);
        } else {
            LOGGER.debug("Test dir will be renamed to custom name.");
            ReportContext.renameTestDir(dirName);
        }
        isCustomTestDirName.set(Boolean.TRUE);
        return testDir;
    }

    public static void emptyTestDirData() {
        testDirectory.remove();
        isCustomTestDirName.set(Boolean.FALSE);
        ReportContext.stopThreadLogAppender();
    }

    public static synchronized File createTestDir() {
        return ReportContext.createTestDir(UUID.randomUUID().toString());
    }

    private static synchronized File createTestDir(String dirName) {
        String directory = String.format(FOLDERS_FORMAT, ReportContext.getBaseDir(), dirName);
        File testDir = new File(directory);
        if (!testDir.exists()) {
            testDir.mkdirs();
            if (!testDir.exists()) {
                throw new RuntimeException("Test Folder(s) not created: " + testDir.getAbsolutePath());
            }
        }
        testDirectory.set(testDir);
        return testDir;
    }

    public static synchronized File getArtifactsFolder() {
        File dir = null;
        try {
            dir = !Configuration.get(Configuration.Parameter.CUSTOM_ARTIFACTS_FOLDER).isEmpty() ? new File(Configuration.get(Configuration.Parameter.CUSTOM_ARTIFACTS_FOLDER)).getCanonicalFile() : new File(ReportContext.getTestDir().getCanonicalPath() + File.separator + ARTIFACTS_FOLDER);
            if (!dir.exists()) {
                if (!dir.mkdir()) {
                    throw new RuntimeException("Artifacts folder not created: " + dir.getAbsolutePath());
                }
                LOGGER.debug("Artifacts folder created: {}", (Object)dir.getAbsolutePath());
            } else {
                LOGGER.debug("Artifacts folder already exists: {}", (Object)dir.getAbsolutePath());
            }
            if (!dir.isDirectory()) {
                throw new RuntimeException("Artifacts folder is not a folder: " + dir.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Artifacts folder not created!");
        }
        return dir;
    }

    public static List<String> listArtifacts(WebDriver driver) {
        List<String> artifactNames = Arrays.stream(Objects.requireNonNull(ReportContext.getArtifactsFolder().listFiles())).map(File::getName).collect(Collectors.toList());
        String hostUrl = ReportContext.getUrl(driver, "");
        String username = ReportContext.getField(hostUrl, 1);
        String password = ReportContext.getField(hostUrl, 2);
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(hostUrl).openConnection();
            con.setInstanceFollowRedirects(true);
            con.setRequestMethod("GET");
            if (!username.isEmpty() && !password.isEmpty()) {
                String usernameColonPassword = username + ":" + password;
                String basicAuthPayload = "Basic " + Base64.getEncoder().encodeToString(usernameColonPassword.getBytes());
                con.addRequestProperty("Authorization", basicAuthPayload);
            }
            int responseCode = con.getResponseCode();
            try (InputStream connectionStream = con.getInputStream();){
                String responseBody = ReportContext.readStream(connectionStream);
                if (responseCode == 404 && responseBody.contains("\"error\":\"invalid session id\",\"message\":\"unknown session")) {
                    throw new RuntimeException("Invalid session id. Something wrong with driver");
                }
                if (responseCode == 200) {
                    String hrefAttributePattern = "href=([\"'])((?:(?!\\1)[^\\\\]|(?:\\\\\\\\)*\\\\[^\\\\])*)\\1";
                    Pattern pattern = Pattern.compile(hrefAttributePattern);
                    Matcher matcher = pattern.matcher(responseBody);
                    while (matcher.find()) {
                        if (artifactNames.contains(matcher.group(2))) continue;
                        artifactNames.add(matcher.group(2));
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.debug("Something went wrong when try to get artifacts from remote", (Throwable)e);
        }
        return artifactNames;
    }

    public static List<File> getArtifacts(WebDriver driver, String pattern) {
        List filteredFilesNames = ReportContext.listArtifacts(driver).stream().filter(fileName -> !fileName.endsWith("/")).filter(fileName -> fileName.matches(pattern)).collect(Collectors.toList());
        ArrayList<File> artifacts = new ArrayList<File>();
        for (String fileName2 : filteredFilesNames) {
            artifacts.add(ReportContext.getArtifact(driver, fileName2));
        }
        return artifacts;
    }

    public static File getArtifact(WebDriver driver, String name) {
        File file = new File(ReportContext.getArtifactsFolder() + File.separator + name);
        if (file.exists()) {
            return file;
        }
        String path = file.getAbsolutePath();
        LOGGER.debug("artifact file to download: {}", (Object)path);
        String url = ReportContext.getUrl(driver, name);
        String username = ReportContext.getField(url, 1);
        String password = ReportContext.getField(url, 2);
        if (!username.isEmpty() && !password.isEmpty()) {
            Authenticator.setDefault(new CustomAuthenticator(username, password));
        }
        if (ReportContext.checkArtifactUsingHttp(url, username, password)) {
            try {
                FileUtils.copyURLToFile((URL)new URL(url), (File)file);
                LOGGER.debug("Successfully downloaded artifact: {}", (Object)name);
            }
            catch (IOException e) {
                LOGGER.error("Artifact: {} wasn't downloaded to {}", new Object[]{url, path, e});
            }
        } else {
            Assert.fail((String)("Unable to find artifact: " + name));
        }
        try {
            Class artifactClass = ClassUtils.getClass((String)"com.zebrunner.agent.core.registrar.Artifact");
            MethodUtils.invokeStaticMethod((Class)artifactClass, (String)"attachToTest", (Object[])new Object[]{name, file});
        }
        catch (Exception e) {
            LOGGER.debug("Cannot attach artifact to the test.", (Throwable)e);
        }
        return file;
    }

    private static boolean checkArtifactUsingHttp(String url, String username, String password) {
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
            con.setRequestMethod("HEAD");
            if (!username.isEmpty() && !password.isEmpty()) {
                String usernameColonPassword = username + ":" + password;
                String basicAuthPayload = "Basic " + Base64.getEncoder().encodeToString(usernameColonPassword.getBytes());
                con.addRequestProperty("Authorization", basicAuthPayload);
            }
            return con.getResponseCode() == 200;
        }
        catch (Exception e) {
            LOGGER.debug("Artifact doesn't exist: " + url, (Throwable)e);
            return false;
        }
    }

    private static String getField(String url, int position) {
        Pattern pattern = Pattern.compile(".*:\\/\\/(.*):(.*)@");
        Matcher matcher = pattern.matcher(url);
        return matcher.find() ? matcher.group(position) : "";
    }

    public static void saveArtifact(String name, InputStream source) throws IOException {
        File artifact = new File(String.format(FOLDERS_FORMAT, ReportContext.getArtifactsFolder(), name));
        boolean isSuccessful = artifact.createNewFile();
        if (!isSuccessful) {
            LOGGER.debug("Artifact already exists!");
        }
        FileUtils.writeByteArrayToFile((File)artifact, (byte[])IOUtils.toByteArray((InputStream)source));
        try {
            Class artifactClass = ClassUtils.getClass((String)"com.zebrunner.agent.core.registrar.Artifact");
            MethodUtils.invokeStaticMethod((Class)artifactClass, (String)"attachToTest", (Object[])new Object[]{name, IOUtils.toByteArray((InputStream)source)});
        }
        catch (Exception e) {
            LOGGER.debug("Cannot attach artifact to the test.", (Throwable)e);
        }
    }

    public static void saveArtifact(File source) throws IOException {
        File artifact = new File(String.format(FOLDERS_FORMAT, ReportContext.getArtifactsFolder(), source.getName()));
        boolean isSuccessful = artifact.createNewFile();
        if (!isSuccessful) {
            LOGGER.debug("Artifact already exists!");
        }
        FileUtils.copyFile((File)source, (File)artifact);
        try {
            Class artifactClass = ClassUtils.getClass((String)"com.zebrunner.agent.core.registrar.Artifact");
            MethodUtils.invokeStaticMethod((Class)artifactClass, (String)"attachToTest", (Object[])new Object[]{source.getName(), artifact});
        }
        catch (Exception e) {
            LOGGER.debug("Cannot attach artifact to the test.", (Throwable)e);
        }
    }

    private static String getUrl(WebDriver driver, String name) {
        String seleniumHost = Configuration.getSeleniumUrl().replace("wd/hub", "download/");
        RemoteWebDriver drv = driver instanceof Decorated ? (RemoteWebDriver)((Decorated)driver).getOriginal() : (RemoteWebDriver)driver;
        String sessionId = drv.getSessionId().toString();
        String url = seleniumHost + sessionId + "/" + name;
        LOGGER.debug("url: {}", (Object)url);
        return url;
    }

    private static void stopThreadLogAppender() {
        try {
            Class logManagerClass = ClassUtils.getClass((String)"org.apache.logging.log4j.LogManager");
            Object loggerContext = MethodUtils.invokeStaticMethod((Class)logManagerClass, (String)"getContext", (Object[])new Object[]{true});
            Object configuration = MethodUtils.invokeMethod((Object)loggerContext, (String)"getConfiguration");
            Object appender = MethodUtils.invokeMethod((Object)configuration, (String)"getAppender", (Object[])new Object[]{"ThreadLogAppender"});
            if (appender != null) {
                MethodUtils.invokeMethod((Object)appender, (String)"stop");
            }
        }
        catch (Exception e) {
            LOGGER.debug("Exception while closing thread log appender.", (Throwable)e);
        }
    }

    private static File renameTestDir(String test) {
        File testDir = testDirectory.get();
        ReportContext.initIsCustomTestDir();
        if (testDir != null && !isCustomTestDirName.get().booleanValue()) {
            File newTestDir = new File(String.format(FOLDERS_FORMAT, ReportContext.getBaseDir(), test.replaceAll(SPACE_PATTERN, "_")));
            if (!newTestDir.exists()) {
                boolean isRenamed = false;
                for (int retry = 5; !isRenamed && retry > 0; --retry) {
                    ReportContext.stopThreadLogAppender();
                    isRenamed = testDir.renameTo(newTestDir);
                    if (isRenamed) continue;
                    CommonUtils.pause(1);
                    System.err.println("renaming failed to '" + newTestDir + "'");
                }
                if (isRenamed) {
                    testDirectory.set(newTestDir);
                    System.out.println("Test directory renamed to '" + newTestDir + "'");
                }
            }
        } else {
            LOGGER.error("Unexpected case with absence of test.log for '{}'", (Object)test);
        }
        return testDir;
    }

    private static void initIsCustomTestDir() {
        if (isCustomTestDirName.get() == null) {
            isCustomTestDirName.set(Boolean.FALSE);
        }
    }

    private static void removeOldReports() {
        File baseDir = new File(String.format(FOLDERS_FORMAT, System.getProperty(ROOT_DIR_SYSTEM_PROPERTY), Configuration.get(Configuration.Parameter.PROJECT_REPORT_DIRECTORY)));
        if (baseDir.exists()) {
            File reportFile = new File(String.format("%s/%s/%s", System.getProperty(ROOT_DIR_SYSTEM_PROPERTY), Configuration.get(Configuration.Parameter.PROJECT_REPORT_DIRECTORY), "emailable-report.html"));
            if (reportFile.exists()) {
                boolean isSuccessful = reportFile.delete();
                if (!isSuccessful) {
                    LOGGER.debug("Something went wrong when try to delete  '{}' report file", (Object)reportFile.getAbsolutePath());
                }
                try {
                    Files.delete(reportFile.toPath());
                }
                catch (IOException e) {
                    System.out.println(e + "\n" + e.getMessage());
                }
            }
            List<File> files = FileManager.getFilesInDir(baseDir);
            ArrayList<File> screenshotFolders = new ArrayList<File>();
            for (File file : files) {
                if (!file.isDirectory() || file.getName().startsWith(".")) continue;
                screenshotFolders.add(file);
            }
            int maxHistory = Configuration.getInt(Configuration.Parameter.MAX_SCREENSHOOT_HISTORY);
            if (maxHistory > 0 && screenshotFolders.size() + 1 > maxHistory) {
                Comparator comp = (file1, file2) -> file2.getName().compareTo(file1.getName());
                screenshotFolders.sort(comp);
                for (int i = maxHistory - 1; i < screenshotFolders.size(); ++i) {
                    if (((File)screenshotFolders.get(i)).getName().equals("gallery-lib")) continue;
                    try {
                        FileUtils.deleteDirectory((File)((File)screenshotFolders.get(i)));
                        continue;
                    }
                    catch (IOException e) {
                        System.out.println(e + "\n" + e.getMessage());
                    }
                }
            }
        }
    }

    public static void generateHtmlReport(String content) {
        String emailableReport = "emailable-report.html";
        File reportFile = new File(String.format("%s/%s/%s", System.getProperty(ROOT_DIR_SYSTEM_PROPERTY), Configuration.get(Configuration.Parameter.PROJECT_REPORT_DIRECTORY), emailableReport));
        File reportFileToBaseDir = new File(String.format(FOLDERS_FORMAT, ReportContext.getBaseDir(), emailableReport));
        try (FileWriter reportFileWriter = new FileWriter(reportFile.getAbsoluteFile());
             BufferedWriter reportBufferedWriter = new BufferedWriter(reportFileWriter);
             FileWriter baseDirFileWriter = new FileWriter(reportFileToBaseDir.getAbsolutePath());
             BufferedWriter baseDirBufferedWriter = new BufferedWriter(baseDirFileWriter);){
            ReportContext.createNewFileIfNotExists(reportFile);
            reportBufferedWriter.write(content);
            ReportContext.createNewFileIfNotExists(reportFileToBaseDir);
            baseDirBufferedWriter.write(content);
        }
        catch (IOException e) {
            LOGGER.error("generateHtmlReport failure", (Throwable)e);
        }
    }

    private static void createNewFileIfNotExists(File file) throws IOException {
        boolean isCreated;
        if (!file.exists() && !(isCreated = file.createNewFile())) {
            throw new RuntimeException("File not created: " + file.getAbsolutePath());
        }
    }

    public static String getTestArtifactsLink() {
        String link = "";
        link = !Configuration.get(Configuration.Parameter.REPORT_URL).isEmpty() ? String.format("%s/%d/artifacts", Configuration.get(Configuration.Parameter.REPORT_URL), rootID) : String.format("file://%s/artifacts", ReportContext.getBaseDirAbsolutePath());
        return link;
    }

    public static String getTestScreenshotsLink() {
        String link = "";
        try {
            if (FileUtils.listFiles((File)ReportContext.getTestDir(), (String[])new String[]{"png"}, (boolean)false).isEmpty()) {
                return link;
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during report directory scanning", (Throwable)e);
        }
        String test = testDirectory.get().getName().replaceAll(SPACE_PATTERN, "_");
        link = !Configuration.get(Configuration.Parameter.REPORT_URL).isEmpty() ? String.format("%s/%d/%s/report.html", Configuration.get(Configuration.Parameter.REPORT_URL), rootID, test) : String.format("file://%s/%s/report.html", ReportContext.getBaseDirAbsolutePath(), test);
        return link;
    }

    public static String getTestLogLink() {
        String link = "";
        File testLogFile = new File(ReportContext.getTestDir() + "/test.log");
        if (!testLogFile.exists()) {
            return link;
        }
        String test = testDirectory.get().getName().replaceAll(SPACE_PATTERN, "_");
        link = !Configuration.get(Configuration.Parameter.REPORT_URL).isEmpty() ? String.format("%s/%d/%s/test.log", Configuration.get(Configuration.Parameter.REPORT_URL), rootID, test) : String.format("file://%s/%s/test.log", ReportContext.getBaseDirAbsolutePath(), test);
        return link;
    }

    public static String getCucumberReportLink() {
        String folder = "cucumber-reports";
        String subFolder = "cucumber-html-reports";
        String fileName = "overview-features.html";
        String link = "";
        if (!Configuration.get(Configuration.Parameter.REPORT_URL).isEmpty()) {
            String reportUrl = Configuration.get(Configuration.Parameter.REPORT_URL);
            if (reportUrl.contains("n/a")) {
                LOGGER.error("Contains n/a. Replace it.");
                reportUrl = reportUrl.replace("n/a", "");
            }
            link = String.format("%s/%d/%s/%s/%s", reportUrl, rootID, folder, subFolder, fileName);
        } else {
            link = String.format("file://%s/%s/%s/%s", ReportContext.getBaseDirAbsolutePath(), folder, subFolder, fileName);
        }
        return link;
    }

    public static String saveScreenshot(BufferedImage screenshot) {
        long now = System.currentTimeMillis();
        executor.execute(new ImageSaverTask(screenshot, String.format("%s/%d.png", ReportContext.getTestDir().getAbsolutePath(), now), Configuration.getInt(Configuration.Parameter.BIG_SCREEN_WIDTH), Configuration.getInt(Configuration.Parameter.BIG_SCREEN_HEIGHT)));
        return String.format("%d.png", now);
    }

    private static void copyGalleryLib() {
        String filesSeparator = FileSystems.getDefault().getSeparator();
        File reportsRootDir = new File(System.getProperty(ROOT_DIR_SYSTEM_PROPERTY) + "/" + Configuration.get(Configuration.Parameter.PROJECT_REPORT_DIRECTORY));
        if (!new File(reportsRootDir.getAbsolutePath() + "/gallery-lib").exists()) {
            try {
                InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream(GALLERY_ZIP);
                if (is == null) {
                    System.out.println("Unable to find in classpath: gallery-lib.zip");
                    return;
                }
                ZipManager.copyInputStream(is, new BufferedOutputStream(new FileOutputStream(reportsRootDir.getAbsolutePath() + "/gallery-lib.zip")));
                ZipManager.unzip(reportsRootDir.getAbsolutePath() + filesSeparator + GALLERY_ZIP, reportsRootDir.getAbsolutePath());
                File zip = new File(reportsRootDir.getAbsolutePath() + filesSeparator + GALLERY_ZIP);
                boolean isSuccessful = zip.delete();
                if (!isSuccessful) {
                    System.out.println("Unable to delete zip: " + zip.getAbsolutePath());
                }
            }
            catch (Exception e) {
                System.out.println("Unable to copyGalleryLib! " + e);
            }
        }
    }

    public static void generateTestReport() {
        File testDir = testDirectory.get();
        try {
            List<File> images = FileManager.getFilesInDir(testDir);
            ArrayList<String> imgNames = new ArrayList<String>();
            for (File file : images) {
                imgNames.add(file.getName());
            }
            imgNames.remove("test.log");
            imgNames.remove("sql.log");
            if (imgNames.isEmpty()) {
                return;
            }
            Collections.sort(imgNames);
            StringBuilder report = new StringBuilder();
            for (String imgName : imgNames) {
                String image = R.REPORT.get("image");
                image = image.replace("${image}", imgName);
                String title = ReportContext.getScreenshotComment(imgName);
                if (title == null) {
                    title = "";
                }
                image = image.replace("${title}", StringUtils.substring((String)title, (int)0, (int)300));
                report.append(image);
            }
            String string2 = R.REPORT.get("container").replace("${images}", report.toString());
            string2 = string2.replace("${title}", TITLE);
            String folder = testDir.getAbsolutePath();
            FileManager.createFileWithContent(folder + REPORT_NAME, string2);
        }
        catch (Exception e) {
            LOGGER.error("generateTestReport failure", (Throwable)e);
        }
    }

    public static void addScreenshotComment(String screenId, String msg) {
        if (!StringUtils.isEmpty((CharSequence)screenId)) {
            screenSteps.put(screenId, msg);
        }
    }

    public static String getScreenshotComment(String screenId) {
        String comment = "";
        if (screenSteps.containsKey(screenId)) {
            comment = screenSteps.get(screenId);
        }
        return comment;
    }

    private static String getBaseDirAbsolutePath() {
        if (baseDirectory != null) {
            return baseDirectory.getAbsolutePath();
        }
        return null;
    }

    private static String readStream(InputStream in) {
        StringBuilder response = new StringBuilder();
        try (InputStreamReader istream = new InputStreamReader(in);
             BufferedReader reader = new BufferedReader(istream);){
            String line = "";
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return response.toString();
    }

    static {
        testDirectory = new InheritableThreadLocal<File>();
        isCustomTestDirName = new InheritableThreadLocal<Boolean>();
        executor = Executors.newCachedThreadPool();
        screenSteps = Collections.synchronizedMap(new HashMap());
    }

    public static class CustomAuthenticator
    extends Authenticator {
        String username;
        String password;

        public CustomAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password.toCharArray());
        }
    }

    private static class ImageSaverTask
    implements Runnable {
        private BufferedImage image;
        private String path;
        private Integer width;
        private Integer height;

        public ImageSaverTask(BufferedImage image, String path, Integer width, Integer height) {
            this.image = image;
            this.path = path;
            this.width = width;
            this.height = height;
        }

        @Override
        public void run() {
            try {
                if (this.width > 0 && this.height > 0) {
                    BufferedImage resizedImage = Scalr.resize((BufferedImage)this.image, (Scalr.Method)Scalr.Method.BALANCED, (Scalr.Mode)Scalr.Mode.FIT_TO_WIDTH, (int)this.width, (int)this.height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
                    if (resizedImage.getHeight() > this.height) {
                        resizedImage = Scalr.crop((BufferedImage)resizedImage, (int)resizedImage.getWidth(), (int)this.height, (BufferedImageOp[])new BufferedImageOp[0]);
                    }
                    ImageIO.write((RenderedImage)resizedImage, "PNG", new File(this.path));
                } else {
                    ImageIO.write((RenderedImage)this.image, "PNG", new File(this.path));
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to save screenshot: {}", (Object)e.getMessage());
            }
        }
    }
}

