/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils.resources;

import com.zebrunner.carina.utils.Configuration;
import com.zebrunner.carina.utils.IWebElement;
import com.zebrunner.carina.utils.resources.Resources;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.asserts.SoftAssert;

public class L10N {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Locale locale = L10N.getLocale(Configuration.get(Configuration.Parameter.LOCALE));
    private static List<ResourceBundle> resBoundles = new ArrayList<ResourceBundle>();
    private static final Properties missedResources = new Properties();
    private static SoftAssert mistakes;

    private L10N() {
    }

    public static void load() {
        mistakes = new SoftAssert();
        ArrayList<CallSite> loadedResources = new ArrayList<CallSite>();
        try {
            for (URL u2 : Resources.getResourceURLs(u -> {
                String s = u.getPath();
                boolean contains = s.contains("L10N");
                if (contains) {
                    LOGGER.debug("L10N: file URL: {}", (Object)u);
                }
                return contains;
            })) {
                LOGGER.debug("Analyzing '{}' L10N resource for loading...", (Object)u2);
                String fileName = FilenameUtils.getBaseName((String)u2.getPath());
                if (u2.getPath().endsWith("L10N.class") || u2.getPath().endsWith("L10N$1.class")) continue;
                if (fileName.lastIndexOf(95) == fileName.length() - 3 || fileName.lastIndexOf(95) == fileName.length() - 5) {
                    LOGGER.debug("'{}' resource IGNORED as it looks like localized resource!", (Object)fileName);
                    continue;
                }
                String filePath = FilenameUtils.getPath((String)u2.getPath());
                int index = filePath.indexOf("L10N");
                if (index == -1) {
                    LOGGER.warn("Unable to find L10N pattern for {} resource!", (Object)u2.getPath());
                    continue;
                }
                String resource = filePath.substring(filePath.indexOf("L10N")).replaceAll("/", ".") + fileName;
                if (!loadedResources.contains(resource)) {
                    loadedResources.add((CallSite)((Object)resource));
                    try {
                        LOGGER.debug("Adding '{}' resource...", (Object)resource);
                        resBoundles.add(ResourceBundle.getBundle(resource, locale));
                        LOGGER.debug("Resource '{}' added.", (Object)resource);
                    }
                    catch (MissingResourceException e) {
                        LOGGER.debug("No resource bundle for the " + resource + " can be found", (Throwable)e);
                    }
                    continue;
                }
                LOGGER.debug("Requested resource '{}' is already loaded into the ResourceBundle!", (Object)resource);
            }
            LOGGER.debug("init: L10N bundle size: {}", (Object)resBoundles.size());
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("L10N folder with resources is missing!");
        }
    }

    public static void load(List<ResourceBundle> resources) {
        mistakes = new SoftAssert();
        resBoundles = resources;
    }

    public static String getText(String key) {
        LOGGER.debug("getText: L10N bundle size: {}", (Object)resBoundles.size());
        for (ResourceBundle bundle : resBoundles) {
            try {
                String value = bundle.getString(key);
                if (!bundle.getLocale().toString().equals(locale.toString())) continue;
                return value;
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return key;
    }

    public static boolean verify(IWebElement element) {
        String key;
        String expectedText;
        boolean isValid;
        if (!Configuration.getBoolean(Configuration.Parameter.LOCALIZATION_TESTING)) {
            return true;
        }
        String actualText = element.getText();
        boolean bl = isValid = actualText.contains(expectedText = L10N.getText(key = element.getName())) && !expectedText.isEmpty();
        if (!isValid) {
            String error = "Expected: '" + expectedText + "', length=" + expectedText.length() + ". Actual: '" + actualText + "', length=" + actualText.length() + ".";
            LOGGER.error(error);
            mistakes.fail(error);
            String newItem = key + "=" + actualText;
            LOGGER.info("Making new localization string: {}", (Object)newItem);
            missedResources.setProperty(key, actualText);
        } else {
            LOGGER.debug("Found localization text '{}' in {} encoding: {}", new Object[]{actualText, L10N.getEncoding(), expectedText});
        }
        return isValid;
    }

    public static void assertAll() {
        mistakes.assertAll();
    }

    public static void setLocale(String loc) {
        LOGGER.warn("Default locale: {} was overriden by {}", (Object)locale, (Object)loc);
        locale = L10N.getLocale(loc);
    }

    public static void flush() {
        if (missedResources.size() == 0) {
            LOGGER.info("There are no new localization properties.");
            return;
        }
        LOGGER.info("New localization for '{}'", (Object)locale);
        LOGGER.info("Properties: {}", (Object)missedResources);
        String missedResorceFile = "missed_" + locale + ".properties";
        try (FileOutputStream fostream = new FileOutputStream(missedResorceFile);
             OutputStreamWriter ostream = new OutputStreamWriter((OutputStream)fostream, L10N.getEncoding());){
            missedResources.store(ostream, null);
        }
        catch (Exception e) {
            LOGGER.error("Unable to store missed resources: {}!", (Object)missedResorceFile, (Object)e);
        }
        missedResources.clear();
    }

    private static String getEncoding() {
        return Configuration.get(Configuration.Parameter.LOCALIZATION_ENCODING).toUpperCase();
    }

    private static Locale getLocale(String locale) {
        String[] localeSetttings = locale.trim().split("_");
        String lang = "";
        String country = "";
        lang = localeSetttings[0];
        if (localeSetttings.length > 1) {
            country = localeSetttings[1];
        }
        return new Locale(lang, country);
    }
}

