/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils.rest;

import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private RestUtil() {
    }

    public static Response sendHttpPost(String contentType, String payload, String httpPostCommand) {
        return RestUtil.sendHttpPost(contentType, payload, httpPostCommand, true);
    }

    public static Response sendHttpPost(String contentType, Map<String, ?> parameters, String httpPostCommand, boolean responseLog) {
        if (responseLog) {
            return (Response)((ResponseSpecification)((RequestSpecification)RestAssured.given().contentType(contentType).formParams(parameters).log().all()).expect().log().all()).when().post(httpPostCommand, new Object[0]);
        }
        return (Response)RestAssured.given().contentType(contentType).formParams(parameters).when().post(httpPostCommand, new Object[0]);
    }

    public static Response sendHttpPost(String contentType, String payload, String httpPostCommand, boolean responseLog) {
        if (responseLog) {
            return (Response)((ResponseSpecification)((RequestSpecification)RestAssured.given().contentType(contentType).body(payload).log().all()).expect().log().all()).when().post(httpPostCommand, new Object[0]);
        }
        return (Response)RestAssured.given().contentType(contentType).body(payload).when().post(httpPostCommand, new Object[0]);
    }

    public static Response sendHttpGet(String contentType, String httpGetCommand) {
        return RestUtil.sendHttpGet(contentType, httpGetCommand, true);
    }

    public static Response sendHttpGet(String contentType, String httpGetCommand, boolean responseLog) {
        if (responseLog) {
            return (Response)((ResponseSpecification)((RequestSpecification)RestAssured.given().contentType(contentType).log().all()).expect().log().all()).when().get(httpGetCommand, new Object[0]);
        }
        return (Response)((RequestSpecification)RestAssured.given().contentType(contentType).log().all()).when().get(httpGetCommand, new Object[0]);
    }

    public static int statusCode(Response response) {
        return response.getStatusCode();
    }

    public static boolean isResponseCorrect(Response response) {
        return RestUtil.isStatusCode(response, 200);
    }

    public static boolean isStatusCode(Response response, int statusCode) {
        return statusCode == RestUtil.statusCode(response);
    }

    public static String statusLine(Response response) {
        return response.getStatusLine();
    }

    public static String stringResponse(Response response) {
        String strResponse = null;
        try {
            strResponse = response.asString();
        }
        catch (Exception e) {
            LOGGER.info("Error: {}", (Object)e.getMessage(), (Object)e);
        }
        return strResponse;
    }

    public static JsonPath jsonResponse(Response response) {
        return response.jsonPath();
    }
}

