/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils.retry;

import com.zebrunner.carina.utils.common.CommonUtils;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class ActionPoller<T> {
    private Duration timeout = Duration.ofSeconds(60L);
    private Duration pollingInterval = Duration.ofSeconds(5L);
    private Supplier<T> task;
    private Predicate<T> successCondition;
    private final List<Consumer<T>> peekActions = new ArrayList<Consumer<T>>();

    private ActionPoller() {
    }

    public static <T> ActionPoller<T> builder() {
        return new ActionPoller<T>();
    }

    public ActionPoller<T> pollEvery(long period, TemporalUnit timeUnit) {
        this.pollingInterval = Duration.of(period, timeUnit);
        return this;
    }

    public ActionPoller<T> stopAfter(long timeout, TemporalUnit timeUnit) {
        this.timeout = Duration.of(timeout, timeUnit);
        return this;
    }

    public ActionPoller<T> peek(Consumer<T> peekAction) {
        this.peekActions.add(peekAction);
        return this;
    }

    public ActionPoller<T> task(Supplier<T> task) {
        this.task = task;
        return this;
    }

    public ActionPoller<T> until(Predicate<T> successCondition) {
        this.successCondition = successCondition;
        return this;
    }

    public Optional<T> execute() {
        this.validateParameters();
        AtomicBoolean stopExecution = this.setupTerminateTask();
        Object result = null;
        while (!stopExecution.get()) {
            Object tempResult = this.task.get();
            this.peekActions.forEach(peekAction -> peekAction.accept(tempResult));
            if (this.successCondition.test(tempResult)) {
                result = tempResult;
                break;
            }
            CommonUtils.pause(this.pollingInterval.getSeconds());
        }
        return Optional.ofNullable(result);
    }

    private AtomicBoolean setupTerminateTask() {
        final AtomicBoolean stopExecution = new AtomicBoolean();
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                stopExecution.set(true);
                timer.cancel();
                timer.purge();
            }
        }, this.timeout.toMillis());
        return stopExecution;
    }

    private void validateParameters() {
        if (this.task == null) {
            throw new IllegalArgumentException("Unable to execute without task.");
        }
        if (this.successCondition == null) {
            throw new IllegalArgumentException("Unable to execute without success condition.");
        }
        if (this.timeout.toMillis() < this.pollingInterval.toMillis()) {
            throw new IllegalArgumentException("Timeout cannot be less than polling interval");
        }
        if (this.timeout.isNegative() || this.pollingInterval.isNegative()) {
            throw new IllegalArgumentException("Timeout or polling interval can't be negative");
        }
    }

    public Predicate<T> getSuccessCondition() {
        return this.successCondition;
    }
}

