/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void removeDirRecurs(String directory) {
        File dir = new File(directory);
        if (dir.exists() && dir.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)dir);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage());
            }
        }
    }

    public static synchronized List<File> getFilesInDir(File directory) {
        ArrayList<File> files = new ArrayList<File>();
        try {
            File[] fileArray = directory.listFiles();
            if (fileArray == null) {
                LOGGER.debug("'{}' does not denote a directory, or if an I/O error occurs when an attempt was made to get a list of files", (Object)directory.getAbsolutePath());
                return files;
            }
            files.addAll(Arrays.asList(fileArray));
        }
        catch (Exception e) {
            LOGGER.error("Unable to get files in dir!", (Throwable)e);
        }
        return files;
    }

    public static void createFileWithContent(String filePath, String content) {
        File file = new File(filePath);
        try {
            boolean isSuccess = file.createNewFile();
            if (!isSuccess) {
                LOGGER.debug("File '{}' already exists.", (Object)file.getAbsolutePath());
            }
        }
        catch (IOException e) {
            LOGGER.debug("Error during creating new file with path {}.", (Object)filePath, (Object)e);
            return;
        }
        try (FileWriter fw = new FileWriter(file);){
            fw.write(content);
        }
        catch (IOException e) {
            LOGGER.debug("Error during writing content to the file.", (Throwable)e);
        }
    }

    public static void zipFiles(String output, File ... files) {
        try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(output));){
            for (File fileToZip : files) {
                zipOut.putNextEntry(new ZipEntry(fileToZip.getName()));
                Files.copy(fileToZip.toPath(), zipOut);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Unable to find file for archive operation!", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("IO exception for archive operation!", (Throwable)e);
        }
    }

    public static String getFileChecksum(Checksum checksumType, File file) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(checksumType.value);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            String string;
            block12: {
                FileChannel channel = fileInputStream.getChannel();
                try {
                    ByteBuffer buf = ByteBuffer.allocateDirect(8192);
                    int buffer = channel.read(buf);
                    while (buffer != -1 && buffer != 0) {
                        buf.flip();
                        byte[] bytes = new byte[buffer];
                        buf.get(bytes);
                        digest.update(bytes, 0, buffer);
                        buf.clear();
                        buffer = channel.read(buf);
                    }
                    string = Base64.encodeBase64String((byte[])digest.digest());
                    if (channel == null) break block12;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return string;
        }
    }

    public static enum Checksum {
        MD5("MD5"),
        SHA_256("SHA-256");

        public final String value;

        private Checksum(String value) {
            this.value = value;
        }
    }
}

