/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell;

import com.zendesk.maxwell.Maxwell;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jgroups.JChannel;
import org.jgroups.protocols.raft.Role;
import org.jgroups.raft.RaftHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxwellHA {
    static final Logger LOGGER = LoggerFactory.getLogger(MaxwellHA.class);
    private final Maxwell maxwell;
    private final String jgroupsConf;
    private final String raftMemberID;
    private final String clientID;
    private boolean hasRun = false;
    private AtomicBoolean isRaftLeader = new AtomicBoolean(false);

    public MaxwellHA(Maxwell maxwell, String jgroupsConf, String raftMemberID, String clientID) {
        this.maxwell = maxwell;
        this.jgroupsConf = jgroupsConf;
        this.raftMemberID = raftMemberID;
        this.clientID = clientID;
    }

    private void run() {
        try {
            if (this.hasRun) {
                this.maxwell.restart();
            } else {
                this.maxwell.start();
            }
            this.hasRun = true;
        }
        catch (Exception e) {
            LOGGER.error("Maxwell terminating due to exception:", (Throwable)e);
            System.exit(1);
        }
    }

    public void startHA() throws Exception {
        JChannel ch = new JChannel(this.jgroupsConf);
        RaftHandle handle = new RaftHandle(ch, null);
        if (this.raftMemberID != null) {
            handle.raftId(this.raftMemberID);
        } else {
            LOGGER.warn("--raft_member_id not specified, using values from " + this.jgroupsConf);
        }
        handle.addRoleListener(role -> {
            if (role == Role.Leader) {
                LOGGER.info("won HA election, starting maxwell");
                this.isRaftLeader.set(true);
                this.run();
                this.isRaftLeader.set(false);
            } else if (this.isRaftLeader.get()) {
                LOGGER.info("Unable to find consensus, stepping down HA leadership");
                this.maxwell.terminate();
                this.isRaftLeader.set(false);
            } else {
                LOGGER.info("lost HA election, current leader: " + handle.leader());
            }
        });
        ch.connect(this.clientID);
        LOGGER.info("enter HA group, current leader: " + handle.leader());
        Thread.sleep(Long.MAX_VALUE);
    }
}

