/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell;

import com.zendesk.maxwell.CaseSensitivity;
import com.zendesk.maxwell.MaxwellCompatibilityError;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxwellMysqlStatus {
    static final Logger LOGGER = LoggerFactory.getLogger(MaxwellMysqlStatus.class);
    private Connection connection;

    public MaxwellMysqlStatus(Connection c) {
        this.connection = c;
    }

    private String sqlStatement(String variableName) {
        return "SHOW VARIABLES LIKE '" + variableName + "'";
    }

    public boolean isMaria() {
        try {
            DatabaseMetaData md = this.connection.getMetaData();
            return md.getDatabaseProductVersion().toLowerCase().contains("mariadb");
        }
        catch (SQLException e) {
            return false;
        }
    }

    public String getVariableState(String variableName, boolean throwOnMissing) throws SQLException, MaxwellCompatibilityError {
        try (Statement stmt = this.connection.createStatement();){
            String string;
            block17: {
                String status;
                ResultSet rs;
                block15: {
                    String string2;
                    block16: {
                        rs = stmt.executeQuery(this.sqlStatement(variableName));
                        try {
                            if (rs.next()) break block15;
                            if (throwOnMissing) {
                                throw new MaxwellCompatibilityError("Could not check state for Mysql variable: " + variableName);
                            }
                            string2 = null;
                            if (rs == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return string2;
                }
                string = status = rs.getString("Value");
                if (rs == null) break block17;
                rs.close();
            }
            return string;
        }
    }

    public String getVariableState(String variableName) throws SQLException {
        try {
            return this.getVariableState(variableName, false);
        }
        catch (MaxwellCompatibilityError e) {
            return null;
        }
    }

    private void ensureVariableState(String variable, String state) throws SQLException, MaxwellCompatibilityError {
        if (!this.getVariableState(variable, true).equals(state)) {
            throw new MaxwellCompatibilityError("variable " + variable + " must be set to '" + state + "'");
        }
    }

    private void ensureServerIDIsSet() throws SQLException, MaxwellCompatibilityError {
        String id = this.getVariableState("server_id", false);
        if ("0".equals(id)) {
            throw new MaxwellCompatibilityError("server_id is '0'.  Maxwell will not function without a server_id being set.");
        }
    }

    private void ensureRowImageFormat() throws SQLException, MaxwellCompatibilityError {
        String rowImageFormat = this.getVariableState("binlog_row_image", false);
        if (rowImageFormat == null) {
            return;
        }
        if (rowImageFormat.equals("MINIMAL")) {
            LOGGER.warn("Warning: binlog_row_image is set to MINIMAL.  This may not be what you want.");
            LOGGER.warn("See http://maxwells-daemon.io/compat for more information.");
        }
    }

    public static void ensureReplicationMysqlState(Connection c) throws SQLException, MaxwellCompatibilityError {
        MaxwellMysqlStatus m = new MaxwellMysqlStatus(c);
        m.ensureServerIDIsSet();
        m.ensureVariableState("log_bin", "ON");
        m.ensureVariableState("binlog_format", "ROW");
        m.ensureRowImageFormat();
    }

    public static void ensureMaxwellMysqlState(Connection c) throws SQLException, MaxwellCompatibilityError {
        MaxwellMysqlStatus m = new MaxwellMysqlStatus(c);
        m.ensureVariableState("read_only", "OFF");
    }

    public static void ensureGtidMysqlState(Connection c) throws SQLException, MaxwellCompatibilityError {
        MaxwellMysqlStatus m = new MaxwellMysqlStatus(c);
        if (m.isMaria()) {
            return;
        }
        m.ensureVariableState("gtid_mode", "ON");
        m.ensureVariableState("log_slave_updates", "ON");
        m.ensureVariableState("enforce_gtid_consistency", "ON");
    }

    public static boolean isMaria(Connection c) {
        MaxwellMysqlStatus m = new MaxwellMysqlStatus(c);
        return m.isMaria();
    }

    public static CaseSensitivity captureCaseSensitivity(Connection c) throws SQLException {
        int value;
        try (Statement stmt = c.createStatement();
             ResultSet rs = stmt.executeQuery("select @@lower_case_table_names");){
            if (!rs.next()) {
                throw new RuntimeException("Could not retrieve @@lower_case_table_names!");
            }
            value = rs.getInt(1);
        }
        switch (value) {
            case 0: {
                return CaseSensitivity.CASE_SENSITIVE;
            }
            case 1: {
                return CaseSensitivity.CONVERT_TO_LOWER;
            }
            case 2: {
                return CaseSensitivity.CONVERT_ON_COMPARE;
            }
        }
        throw new RuntimeException("Unknown value for @@lower_case_table_names: " + value);
    }
}

