/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.bootstrap;

import com.zendesk.maxwell.bootstrap.MaxwellBootstrapUtilityConfig;
import com.zendesk.maxwell.util.C3P0ConnectionPool;
import com.zendesk.maxwell.util.ConnectionPool;
import com.zendesk.maxwell.util.Logging;
import java.io.Console;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxwellBootstrapUtility {
    static final Logger LOGGER = LoggerFactory.getLogger(MaxwellBootstrapUtility.class);
    private static final long UPDATE_PERIOD_MILLIS = 250L;
    private static final long DISPLAY_PROGRESS_WARMUP_MILLIS = 5000L;
    private static final long NON_CONSOLE_DISPLAY_LINE_COUNT_MULTIPLE = 100000L;
    private static Console console = System.console();
    private boolean isComplete = false;

    private void run(String[] argv) throws Exception {
        MaxwellBootstrapUtilityConfig config = new MaxwellBootstrapUtilityConfig(argv);
        if (config.log_level != null) {
            Logging.setLevel(config.log_level);
        }
        ConnectionPool connectionPool = this.getConnectionPool(config);
        ConnectionPool replConnectionPool = this.getReplicationConnectionPool(config);
        try (Connection connection = connectionPool.getConnection();
             Connection replicationConnection = replConnectionPool.getConnection();){
            long rowId;
            if (config.abortBootstrapID != null) {
                this.getInsertedRowsCount(connection, config.abortBootstrapID);
                this.removeBootstrapRow(connection, config.abortBootstrapID);
                return;
            }
            if (config.monitorBootstrapID != null) {
                this.getInsertedRowsCount(connection, config.monitorBootstrapID);
                rowId = config.monitorBootstrapID;
            } else {
                Long totalRows = this.calculateRowCount(replicationConnection, config.databaseName, config.tableName, config.whereClause);
                rowId = this.insertBootstrapStartRow(connection, config.databaseName, config.tableName, config.whereClause, config.clientID, config.comment, totalRows);
            }
            try {
                this.monitorProgress(connection, rowId);
            }
            catch (MissingBootstrapRowException e) {
                LOGGER.error("bootstrap aborted.");
                Runtime.getRuntime().halt(1);
            }
        }
        catch (SQLException e) {
            LOGGER.error("failed to connect to mysql server @ " + config.getConnectionURI());
            LOGGER.error(e.getLocalizedMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void monitorProgress(Connection connection, Long rowId) throws SQLException, MissingBootstrapRowException {
        this.addMonitorShutdownHook(rowId);
        long rowCount = this.getTotalRowCount(connection, rowId);
        long initialRowCount = this.getInsertedRowsCount(connection, rowId);
        Long startedTimeMillis = null;
        long insertedRowsCount = initialRowCount;
        while (!this.isComplete) {
            if (insertedRowsCount < rowCount) {
                if (startedTimeMillis == null && insertedRowsCount > 0L) {
                    startedTimeMillis = System.currentTimeMillis();
                }
                insertedRowsCount = this.getInsertedRowsCount(connection, rowId);
            }
            this.isComplete = this.getIsComplete(connection, rowId);
            this.displayProgress(rowCount, insertedRowsCount, initialRowCount, startedTimeMillis);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.displayLine("");
    }

    private void addMonitorShutdownHook(final Long rowId) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (!MaxwellBootstrapUtility.this.isComplete && console != null) {
                    System.out.println("");
                    System.out.println("Exiting monitor.  Bootstrap will continue in the background.");
                    System.out.println("To abort, run maxwell-bootstrap --abort " + rowId);
                    System.out.println("To resume monitoring, run maxwell-bootstrap --monitor " + rowId);
                }
            }
        });
    }

    private long getInsertedRowsCount(Connection connection, long rowId) throws SQLException, MissingBootstrapRowException {
        String sql = "select inserted_rows from `bootstrap` where id = ?";
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setLong(1, rowId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    long l = resultSet.getLong(1);
                    return l;
                }
                throw new MissingBootstrapRowException(rowId);
            }
        }
    }

    private boolean getIsComplete(Connection connection, long rowId) throws SQLException, MissingBootstrapRowException {
        String sql = "select is_complete from `bootstrap` where id = ?";
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setLong(1, rowId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    boolean bl = resultSet.getInt(1) == 1;
                    return bl;
                }
                throw new MissingBootstrapRowException(rowId);
            }
        }
    }

    private ConnectionPool getConnectionPool(MaxwellBootstrapUtilityConfig config) throws SQLException {
        String connectionURI = config.getConnectionURI();
        System.out.println("connecting to " + connectionURI);
        return new C3P0ConnectionPool(connectionURI, config.mysql.user, config.mysql.password);
    }

    private ConnectionPool getReplicationConnectionPool(MaxwellBootstrapUtilityConfig config) throws SQLException {
        String connectionURI = config.getReplicationConnectionURI();
        return new C3P0ConnectionPool(connectionURI, config.replicationMysql.user, config.replicationMysql.password);
    }

    private Long getTotalRowCount(Connection connection, Long bootstrapRowID) throws SQLException, MissingBootstrapRowException {
        try (Statement stmt = connection.createStatement();
             ResultSet resultSet = stmt.executeQuery("select total_rows from `bootstrap` where id = " + bootstrapRowID);){
            if (resultSet.next()) {
                Long l = resultSet.getLong(1);
                return l;
            }
            throw new MissingBootstrapRowException(bootstrapRowID);
        }
    }

    private Long calculateRowCount(Connection connection, String db, String table, String whereClause) throws SQLException {
        LOGGER.info("counting rows");
        Object sql = String.format("select count(*) from `%s`.`%s`", db, table);
        if (whereClause != null) {
            sql = (String)sql + String.format(" where %s", whereClause);
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement((String)sql);){
            Long l;
            block13: {
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    resultSet.next();
                    l = resultSet.getLong(1);
                    if (resultSet == null) break block13;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return l;
        }
    }

    private long insertBootstrapStartRow(Connection connection, String db, String table, String whereClause, String clientID, String comment, Long totalRows) throws SQLException {
        LOGGER.info("inserting bootstrap start row");
        String sql = "insert into `bootstrap` (database_name, table_name, where_clause, total_rows, client_id, comment) values(?, ?, ?, ?, ?, ?)";
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql, 1);){
            long l;
            block12: {
                preparedStatement.setString(1, db);
                preparedStatement.setString(2, table);
                preparedStatement.setString(3, whereClause);
                preparedStatement.setLong(4, totalRows);
                preparedStatement.setString(5, clientID);
                preparedStatement.setString(6, comment);
                preparedStatement.execute();
                ResultSet generatedKeys = preparedStatement.getGeneratedKeys();
                try {
                    generatedKeys.next();
                    l = generatedKeys.getLong(1);
                    if (generatedKeys == null) break block12;
                }
                catch (Throwable throwable) {
                    if (generatedKeys != null) {
                        try {
                            generatedKeys.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                generatedKeys.close();
            }
            return l;
        }
    }

    private void removeBootstrapRow(Connection connection, long rowId) throws SQLException {
        LOGGER.info("deleting bootstrap start row");
        String sql = "delete from `bootstrap` where id = ?";
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setLong(1, rowId);
            preparedStatement.execute();
        }
    }

    private void displayProgress(long total, long count, long initialCount, Long startedTimeMillis) {
        if (startedTimeMillis == null) {
            this.displayLine("waiting for bootstrap to start... ");
        } else if (count < total) {
            long currentTimeMillis = System.currentTimeMillis();
            long elapsedMillis = currentTimeMillis - startedTimeMillis;
            long predictedTotalMillis = (long)((float)elapsedMillis / (float)(count - initialCount) * (float)(total - initialCount));
            long remainingMillis = predictedTotalMillis - elapsedMillis;
            String duration = this.prettyDuration(remainingMillis, elapsedMillis);
            this.displayLine(String.format("%d / %d (%.2f%%) %s", count, total, (double)count * 100.0 / (double)total, duration), count);
        } else {
            this.displayLine("waiting for bootstrap to stop... ");
        }
    }

    private String prettyDuration(long millis, long elapsedMillis) {
        if (elapsedMillis < 5000L) {
            return "";
        }
        long d = millis / 86400000L;
        long h = millis / 3600000L % 24L;
        long m = millis / 60000L % 60L;
        long s = millis / 1000L % 60L;
        if (d > 0L) {
            return String.format("- %d days %02dh %02dm %02ds remaining ", d, h, m, s);
        }
        if (h > 0L) {
            return String.format("- %02dh %02dm %02ds remaining ", h, m, s);
        }
        if (m > 0L) {
            return String.format("- %02dm %02ds remaining ", m, s);
        }
        if (s > 0L) {
            return String.format("- %02ds remaining ", s);
        }
        return "";
    }

    private void displayLine(String line, long count) {
        if (console == null && count > 0L && count % 100000L == 0L) {
            System.out.println(line);
        } else {
            this.displayLine(line);
        }
    }

    private void displayLine(String line) {
        if (console != null) {
            String ansiClearLine = "\u001b[2K";
            String ansiMoveCursorToColumnZero = "\u001b[G";
            System.out.print(ansiClearLine + ansiMoveCursorToColumnZero + line);
            System.out.flush();
        }
    }

    public static void main(String[] args) {
        try {
            new MaxwellBootstrapUtility().run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            LOGGER.info("done.");
        }
    }

    protected class MissingBootstrapRowException
    extends Exception {
        MissingBootstrapRowException(Long rowID) {
            super("Could not find bootstrap row with id: " + rowID);
        }
    }
}

