/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.filtering;

import com.zendesk.maxwell.filtering.FilterPatternType;
import com.zendesk.maxwell.filtering.FilterResult;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class FilterPattern {
    protected final FilterPatternType type;
    private final Pattern dbPattern;
    private final Pattern tablePattern;

    public FilterPattern(FilterPatternType type, Pattern dbPattern, Pattern tablePattern) {
        this.type = type;
        this.dbPattern = dbPattern;
        this.tablePattern = tablePattern;
    }

    protected boolean appliesTo(String database, String table) {
        return !(database != null && !this.dbPattern.matcher(database).find() || table != null && !this.tablePattern.matcher(table).find());
    }

    public void match(String database, String table, FilterResult match) {
        if (this.appliesTo(database, table)) {
            match.include = this.type == FilterPatternType.INCLUDE;
        }
    }

    public void matchValue(String database, String table, Map<String, Object> data, FilterResult match) {
        this.match(database, table, match);
    }

    public FilterPatternType getType() {
        return this.type;
    }

    public Pattern getDatabasePattern() {
        return this.dbPattern;
    }

    public Pattern getTablePattern() {
        return this.tablePattern;
    }

    protected String patternToString(Pattern p) {
        String s = p.pattern();
        if (s.equals("")) {
            return "*";
        }
        if (s.startsWith("^") && s.endsWith("$")) {
            return s.substring(1, s.length() - 1);
        }
        return "/" + s + "/";
    }

    public String toString() {
        Object s = "";
        switch (this.type) {
            case INCLUDE: {
                s = (String)s + "include: ";
                break;
            }
            case EXCLUDE: {
                s = (String)s + "exclude: ";
                break;
            }
            case BLACKLIST: {
                s = (String)s + "blacklist: ";
            }
        }
        return (String)s + this.patternToString(this.dbPattern) + "." + this.patternToString(this.tablePattern);
    }

    public boolean couldIncludeColumn(String database, String table, Set<String> columns) {
        return false;
    }
}

