/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.monitoring;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.filtering.InvalidFilterException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxwellConfigServlet
extends HttpServlet {
    private static final String CONTENT_TYPE = "application/json";
    private static final ObjectMapper mapper = new ObjectMapper();
    static final Logger LOGGER = LoggerFactory.getLogger(MaxwellConfigServlet.class);
    private final MaxwellContext context;

    public MaxwellConfigServlet(MaxwellContext context) {
        this.context = context;
    }

    private void handleConfigUpdateRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        SerializedConfig sconfig;
        try {
            String reqbody = req.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            sconfig = (SerializedConfig)mapper.readValue(reqbody, SerializedConfig.class);
        }
        catch (Exception e) {
            resp.setStatus(400);
            resp.setContentType(CONTENT_TYPE);
            try (PrintWriter writer = resp.getWriter();){
                writer.println(ErrorResponse.getErrorResponseString(400, String.format("error processing body: %s", e.getMessage())));
            }
            return;
        }
        try {
            this.applySerializedConfig(sconfig);
            resp.setStatus(200);
            resp.setContentType(CONTENT_TYPE);
            try (PrintWriter writer = resp.getWriter();){
                writer.println(this.getSerializedConfig());
            }
        }
        catch (InvalidFilterException e) {
            resp.setStatus(400);
            resp.setContentType(CONTENT_TYPE);
            try (PrintWriter writer = resp.getWriter();){
                writer.println(ErrorResponse.getErrorResponseString(400, String.format("invalid filter: %s", e.getMessage())));
            }
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.handleConfigUpdateRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.handleConfigUpdateRequest(req, resp);
    }

    protected void doPatch(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.handleConfigUpdateRequest(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        resp.setContentType(CONTENT_TYPE);
        try (PrintWriter writer = resp.getWriter();){
            writer.println(this.getSerializedConfig());
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getMethod().equalsIgnoreCase("PATCH")) {
            this.doPatch(request, response);
        } else {
            super.service(request, response);
        }
    }

    private String getSerializedConfig() throws JsonProcessingException {
        SerializedConfig sconfig = new SerializedConfig();
        String filterstring = this.context.getFilter().toString();
        if (!filterstring.equals("")) {
            sconfig.filter = filterstring;
        }
        return mapper.writeValueAsString((Object)sconfig);
    }

    private void applySerializedConfig(SerializedConfig sconfig) throws InvalidFilterException {
        if (sconfig.filter != null) {
            this.context.getFilter().set(sconfig.filter);
            LOGGER.info("updated filter: " + sconfig.filter);
        }
    }

    private static class ErrorResponse {
        public int code;
        public String message;

        public ErrorResponse(int code, String message) {
            this.code = code;
            this.message = message;
        }

        public static String getErrorResponseString(int code, String message) throws JsonProcessingException {
            ErrorResponse errResponse = new ErrorResponse(code, message);
            return String.format("{\"error\":%s}", mapper.writeValueAsString((Object)errResponse));
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class SerializedConfig {
        public String filter;

        private SerializedConfig() {
        }
    }
}

