/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.monitoring;

import com.zendesk.maxwell.monitoring.MaxwellDiagnostic;
import java.util.List;
import java.util.Map;

public class MaxwellDiagnosticResult {
    private final boolean success;
    private final boolean mandatoryFailed;
    private final List<Check> checks;

    public MaxwellDiagnosticResult(List<Check> checks) {
        this.success = checks.stream().allMatch(Check::isSuccess);
        this.mandatoryFailed = checks.stream().anyMatch(check -> !check.success && check.mandatory);
        this.checks = checks;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isMandatoryFailed() {
        return this.mandatoryFailed;
    }

    public List<Check> getChecks() {
        return this.checks;
    }

    public static class Check {
        private final String name;
        private final boolean success;
        private final boolean mandatory;
        private final String resource;
        private final Map<String, String> info;

        public Check(MaxwellDiagnostic diagnostic, boolean success, Map<String, String> info) {
            this.name = diagnostic.getName();
            this.success = success;
            this.mandatory = diagnostic.isMandatory();
            this.resource = diagnostic.getResource();
            this.info = info;
        }

        public String getName() {
            return this.name;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public String getResource() {
            return this.resource;
        }

        public Map<String, String> getInfo() {
            return this.info;
        }
    }
}

