/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.monitoring;

import com.codahale.metrics.health.HealthCheck;
import com.zendesk.maxwell.MaxwellConfig;
import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.monitoring.MaxwellDiagnosticContext;
import com.zendesk.maxwell.monitoring.MaxwellHTTPServerWorker;
import com.zendesk.maxwell.monitoring.MaxwellHealthCheck;
import com.zendesk.maxwell.monitoring.MaxwellMetrics;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxwellHTTPServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MaxwellHTTPServer.class);

    public static void startIfRequired(MaxwellContext context) throws IOException {
        MaxwellMetrics.Registries metricsRegistries = MaxwellHTTPServer.getMetricsRegistries(context);
        MaxwellDiagnosticContext diagnosticContext = MaxwellHTTPServer.getDiagnosticContext(context);
        if (metricsRegistries != null || diagnosticContext != null || context.getConfig().enableHttpConfig) {
            LOGGER.info("Maxwell http server starting");
            int port = context.getConfig().httpPort;
            String httpBindAddress = context.getConfig().httpBindAddress;
            String pathPrefix = context.getConfig().httpPathPrefix;
            MaxwellHTTPServerWorker maxwellHTTPServerWorker = new MaxwellHTTPServerWorker(httpBindAddress, port, pathPrefix, metricsRegistries, diagnosticContext, context);
            Thread thread = new Thread(maxwellHTTPServerWorker);
            context.addTask(maxwellHTTPServerWorker);
            thread.setUncaughtExceptionHandler((t, e) -> {
                LOGGER.error("Maxwell http server failure", e);
                context.terminate((Exception)e);
            });
            thread.setDaemon(true);
            thread.start();
            LOGGER.info("Maxwell http server started on port " + port);
        }
    }

    private static MaxwellMetrics.Registries getMetricsRegistries(MaxwellContext context) throws IOException {
        MaxwellConfig config = context.getConfig();
        String reportingType = config.metricsReportingType;
        if (reportingType != null && reportingType.contains("http")) {
            if (config.customHealthFactory != null) {
                context.healthCheckRegistry.register("MaxwellHealth", (HealthCheck)config.customHealthFactory.createHealthCheck(context.getProducer()));
            } else {
                context.healthCheckRegistry.register("MaxwellHealth", (HealthCheck)new MaxwellHealthCheck(context.getProducer()));
            }
            return new MaxwellMetrics.Registries(context.metricRegistry, context.healthCheckRegistry);
        }
        return null;
    }

    private static MaxwellDiagnosticContext getDiagnosticContext(MaxwellContext context) {
        MaxwellDiagnosticContext.Config diagnosticConfig = context.getConfig().diagnosticConfig;
        if (diagnosticConfig.enable) {
            return context.getDiagnosticContext();
        }
        return null;
    }
}

