/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.monitoring;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reporter;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jvm.CachedThreadStatesGaugeSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.viafoura.metrics.datadog.DatadogReporter;
import com.viafoura.metrics.datadog.transport.HttpTransport;
import com.viafoura.metrics.datadog.transport.Transport;
import com.viafoura.metrics.datadog.transport.UdpTransport;
import com.zendesk.maxwell.MaxwellConfig;
import com.zendesk.maxwell.monitoring.Metrics;
import io.opencensus.contrib.dropwizard.DropWizardMetrics;
import io.opencensus.exporter.stats.stackdriver.StackdriverStatsExporter;
import io.opencensus.metrics.export.MetricProducer;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxwellMetrics
implements Metrics {
    static final String reportingTypeSlf4j = "slf4j";
    static final String reportingTypeJmx = "jmx";
    static final String reportingTypeHttp = "http";
    static final String reportingTypeDataDog = "datadog";
    static final String reportingTypeStackdriver = "stackdriver";
    private static final Logger LOGGER = LoggerFactory.getLogger(MaxwellMetrics.class);
    private final ArrayList<Reporter> reporters = new ArrayList();
    private final MetricRegistry registry;
    private String metricsPrefix;

    public MaxwellMetrics(MaxwellConfig config, MetricRegistry registry) {
        this.registry = registry;
        this.setup(config);
    }

    private void setup(MaxwellConfig config) {
        this.metricsPrefix = config.metricsPrefix;
        if (config.metricsReportingType == null) {
            if (this.hasMetricsConfig(config)) {
                LOGGER.info("Found HTTP server configuration, enabling HTTP-based metrics");
                config.metricsReportingType = reportingTypeHttp;
            } else {
                return;
            }
        }
        if (config.metricsJvm) {
            this.registry.register(this.metricName("jvm", "memory_usage"), (Metric)new MemoryUsageGaugeSet());
            this.registry.register(this.metricName("jvm", "gc"), (Metric)new GarbageCollectorMetricSet());
            this.registry.register(this.metricName("jvm", "class_loading"), (Metric)new ClassLoadingGaugeSet());
            this.registry.register(this.metricName("jvm", "file_descriptor_ratio"), (Metric)new FileDescriptorRatioGauge());
            this.registry.register(this.metricName("jvm", "thread_states"), (Metric)new CachedThreadStatesGaugeSet(60L, TimeUnit.SECONDS));
        }
        if (config.metricsReportingType.contains(reportingTypeSlf4j)) {
            Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)this.registry).outputTo(LOGGER).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
            reporter.start(config.metricsSlf4jInterval.longValue(), TimeUnit.SECONDS);
            this.reporters.add((Reporter)reporter);
            LOGGER.info("Slf4j metrics reporter enabled");
        }
        if (config.metricsReportingType.contains(reportingTypeJmx)) {
            JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
            jmxReporter.start();
            this.reporters.add((Reporter)jmxReporter);
            LOGGER.info("JMX metrics reporter enabled");
            if (System.getProperty("com.sun.management.jmxremote") == null) {
                LOGGER.warn("JMX remote is disabled");
            } else {
                String portString = System.getProperty("com.sun.management.jmxremote.port");
                if (portString != null) {
                    LOGGER.info("JMX running on port " + Integer.parseInt(portString));
                }
            }
        }
        if (config.metricsReportingType.contains(reportingTypeDataDog)) {
            UdpTransport transport;
            if (config.metricsDatadogType.contains(reportingTypeHttp)) {
                LOGGER.info("Enabling HTTP Datadog reporting to site " + config.metricsDatadogSite);
                HttpTransport.Builder builder = new HttpTransport.Builder().withApiKey(config.metricsDatadogAPIKey);
                if (config.metricsDatadogSite.contains("eu")) {
                    builder.withEuSite();
                }
                transport = builder.build();
            } else {
                LOGGER.info("Enabling UDP Datadog reporting with host " + config.metricsDatadogHost + ", port " + config.metricsDatadogPort);
                transport = new UdpTransport.Builder().withStatsdHost(config.metricsDatadogHost).withPort(config.metricsDatadogPort).build();
            }
            DatadogReporter reporter = DatadogReporter.forRegistry((MetricRegistry)this.registry).withTransport((Transport)transport).withExpansions(EnumSet.of(DatadogReporter.Expansion.COUNT, new DatadogReporter.Expansion[]{DatadogReporter.Expansion.RATE_1_MINUTE, DatadogReporter.Expansion.RATE_15_MINUTE, DatadogReporter.Expansion.MEDIAN, DatadogReporter.Expansion.P95, DatadogReporter.Expansion.P99})).withTags(MaxwellMetrics.getDatadogTags(config.metricsDatadogTags)).build();
            reporter.start(config.metricsDatadogInterval.longValue(), TimeUnit.SECONDS);
            this.reporters.add((Reporter)reporter);
            LOGGER.info("Datadog reporting enabled");
        }
        if (config.metricsReportingType.contains(reportingTypeStackdriver)) {
            io.opencensus.metrics.Metrics.getExportComponent().getMetricProducerManager().add((MetricProducer)new DropWizardMetrics(Collections.singletonList(this.registry)));
            try {
                StackdriverStatsExporter.createAndRegister();
            }
            catch (IOException e) {
                LOGGER.error("Maxwell encountered an error in creating the stackdriver exporter.", (Throwable)e);
            }
            LOGGER.info("Stackdriver metrics reporter enabled");
        }
        if (config.metricsReportingType.contains(reportingTypeHttp)) {
            CollectorRegistry.defaultRegistry.register((Collector)new DropwizardExports(this.registry));
        }
    }

    private static ArrayList<String> getDatadogTags(String datadogTags) {
        ArrayList<String> tags = new ArrayList<String>();
        for (String tag : datadogTags.split(",")) {
            if (StringUtils.isEmpty((String)tag)) continue;
            tags.add(tag);
        }
        return tags;
    }

    @Override
    public String metricName(String ... names) {
        return MetricRegistry.name((String)this.metricsPrefix, (String[])names);
    }

    public void stop() throws IOException {
        for (Reporter r : this.reporters) {
            r.close();
        }
    }

    @Override
    public MetricRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public <T extends Metric> void register(String name, T metric) throws IllegalArgumentException {
        this.getRegistry().register(name, metric);
    }

    private boolean hasMetricsConfig(MaxwellConfig config) {
        return config.httpPort != 8080 || !config.httpPathPrefix.equals("/") || config.httpBindAddress != null;
    }

    static class Registries {
        final MetricRegistry metricRegistry;
        final HealthCheckRegistry healthCheckRegistry;

        Registries(MetricRegistry metricRegistry, HealthCheckRegistry healthCheckRegistry) {
            this.metricRegistry = metricRegistry;
            this.healthCheckRegistry = healthCheckRegistry;
        }
    }
}

