/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.producer;

import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.producer.AbstractProducer;
import com.zendesk.maxwell.row.RowMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class FileProducer
extends AbstractProducer {
    private final File file;
    private final FileWriter fileWriter;

    public FileProducer(MaxwellContext context, String filename) throws IOException {
        super(context);
        this.file = new File(filename);
        this.fileWriter = new FileWriter(this.file, true);
    }

    @Override
    public void push(RowMap r) throws Exception {
        if (!r.shouldOutput(this.outputConfig)) {
            this.context.setPosition(r);
            return;
        }
        String output = r.toJSON(this.outputConfig);
        if (output != null) {
            this.fileWriter.write(r.toJSON(this.outputConfig));
            this.fileWriter.write(10);
            this.fileWriter.flush();
        }
        this.context.setPosition(r);
    }
}

