/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.producer;

import com.amazonaws.services.kinesis.producer.Attempt;
import com.amazonaws.services.kinesis.producer.UserRecordFailedException;
import com.amazonaws.services.kinesis.producer.UserRecordResult;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.producer.AbstractAsyncProducer;
import com.zendesk.maxwell.replication.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KinesisCallback
implements FutureCallback<UserRecordResult> {
    public static final Logger logger = LoggerFactory.getLogger(KinesisCallback.class);
    private final AbstractAsyncProducer.CallbackCompleter cc;
    private final Position position;
    private final String json;
    private MaxwellContext context;
    private final String key;
    private Counter succeededMessageCount;
    private Counter failedMessageCount;
    private Meter succeededMessageMeter;
    private Meter failedMessageMeter;

    public KinesisCallback(AbstractAsyncProducer.CallbackCompleter cc, Position position, String key, String json, Counter producedMessageCount, Counter failedMessageCount, Meter producedMessageMeter, Meter failedMessageMeter, MaxwellContext context) {
        this.cc = cc;
        this.position = position;
        this.key = key;
        this.json = json;
        this.succeededMessageCount = producedMessageCount;
        this.failedMessageCount = failedMessageCount;
        this.succeededMessageMeter = producedMessageMeter;
        this.failedMessageMeter = failedMessageMeter;
        this.context = context;
    }

    public void onFailure(Throwable t) {
        logger.error(t.getClass().getSimpleName() + " @ " + this.position + " -- " + this.key);
        logger.error(t.getLocalizedMessage());
        this.failedMessageCount.inc();
        this.failedMessageMeter.mark();
        if (t instanceof UserRecordFailedException) {
            Attempt last = (Attempt)Iterables.getLast((Iterable)((UserRecordFailedException)t).getResult().getAttempts());
            logger.error(String.format("Record failed to put - %s : %s", last.getErrorCode(), last.getErrorMessage()));
        }
        logger.error("Exception during put", t);
        if (!this.context.getConfig().ignoreProducerError) {
            this.context.terminate(new RuntimeException(t));
        } else {
            this.cc.markCompleted();
        }
    }

    public void onSuccess(UserRecordResult result) {
        this.succeededMessageCount.inc();
        this.succeededMessageMeter.mark();
        if (logger.isDebugEnabled()) {
            logger.debug("->  key:{}, shard id:{}, sequence number:{}\n   {}\n   {}\n", new Object[]{this.key, result.getShardId(), result.getSequenceNumber(), this.json, this.position});
        }
        this.cc.markCompleted();
    }
}

