/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.producer;

import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.producer.AbstractProducer;
import com.zendesk.maxwell.producer.KafkaProducerDiagnostic;
import com.zendesk.maxwell.producer.MaxwellKafkaProducerWorker;
import com.zendesk.maxwell.row.RowMap;
import com.zendesk.maxwell.util.StoppableTask;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;

public class MaxwellKafkaProducer
extends AbstractProducer {
    private final ArrayBlockingQueue<RowMap> queue = new ArrayBlockingQueue(100);
    private final MaxwellKafkaProducerWorker worker;

    public MaxwellKafkaProducer(MaxwellContext context, Properties kafkaProperties, String kafkaTopic) {
        super(context);
        this.worker = new MaxwellKafkaProducerWorker(context, kafkaProperties, kafkaTopic, this.queue);
        Thread thread = new Thread((Runnable)this.worker, "maxwell-kafka-worker");
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void push(RowMap r) throws Exception {
        this.queue.put(r);
    }

    @Override
    public StoppableTask getStoppableTask() {
        return this.worker;
    }

    @Override
    public KafkaProducerDiagnostic getDiagnostic() {
        return new KafkaProducerDiagnostic(this.worker, this.context.getConfig(), this.context.getPositionStoreThread());
    }
}

