/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.producer;

import com.amazonaws.services.kinesis.producer.KinesisProducer;
import com.amazonaws.services.kinesis.producer.KinesisProducerConfiguration;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.producer.AbstractAsyncProducer;
import com.zendesk.maxwell.producer.KinesisCallback;
import com.zendesk.maxwell.producer.partitioners.MaxwellKinesisPartitioner;
import com.zendesk.maxwell.row.RowMap;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxwellKinesisProducer
extends AbstractAsyncProducer {
    private static final Logger logger = LoggerFactory.getLogger(MaxwellKinesisProducer.class);
    private final MaxwellKinesisPartitioner partitioner;
    private final KinesisProducer kinesisProducer;
    private final String kinesisStream;

    public MaxwellKinesisProducer(MaxwellContext context, String kinesisStream) {
        super(context);
        String partitionKey = context.getConfig().producerPartitionKey;
        String partitionColumns = context.getConfig().producerPartitionColumns;
        String partitionFallback = context.getConfig().producerPartitionFallback;
        boolean kinesisMd5Keys = context.getConfig().kinesisMd5Keys;
        this.partitioner = new MaxwellKinesisPartitioner(partitionKey, partitionColumns, partitionFallback, kinesisMd5Keys);
        this.kinesisStream = kinesisStream;
        Path path = Paths.get("kinesis-producer-library.properties", new String[0]);
        if (Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
            KinesisProducerConfiguration config = KinesisProducerConfiguration.fromPropertiesFile((String)path.toString());
            this.kinesisProducer = new KinesisProducer(config);
        } else {
            this.kinesisProducer = new KinesisProducer();
        }
    }

    @Override
    public void sendAsync(RowMap r, AbstractAsyncProducer.CallbackCompleter cc) throws Exception {
        String key = this.partitioner.getKinesisKey(r);
        String value = r.toJSON(this.outputConfig);
        int vsize = value.length();
        ByteBuffer encodedValue = ByteBuffer.wrap(value.getBytes("UTF-8"));
        if (!KinesisCallback.logger.isDebugEnabled()) {
            value = null;
        }
        KinesisCallback callback = new KinesisCallback(cc, r.getNextPosition(), key, value, this.succeededMessageCount, this.failedMessageCount, this.succeededMessageMeter, this.failedMessageMeter, this.context);
        try {
            ListenableFuture future = this.kinesisProducer.addUserRecord(this.kinesisStream, key, encodedValue);
            Futures.addCallback((ListenableFuture)future, (FutureCallback)callback, (Executor)MoreExecutors.directExecutor());
        }
        catch (IllegalArgumentException t) {
            callback.onFailure(t);
            logger.error("Database:" + r.getDatabase() + ", Table:" + r.getTable() + ", PK:" + r.getRowIdentity().toConcatString() + ", Size:" + Integer.toString(vsize));
        }
    }

    public void close() {
        this.kinesisProducer.destroy();
    }
}

