/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.producer;

import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.producer.AbstractProducer;
import com.zendesk.maxwell.producer.MaxwellPubsubProducerWorker;
import com.zendesk.maxwell.row.RowMap;
import com.zendesk.maxwell.util.StoppableTask;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxwellPubsubProducer
extends AbstractProducer {
    public static final Logger LOGGER = LoggerFactory.getLogger(MaxwellPubsubProducer.class);
    private final ArrayBlockingQueue<RowMap> queue = new ArrayBlockingQueue(100);
    private final MaxwellPubsubProducerWorker worker;

    public MaxwellPubsubProducer(MaxwellContext context, String pubsubProjectId, String pubsubTopic, String ddlPubsubTopic, String pubsubMessageOrderingKey, String pubsubEmulator) throws IOException {
        super(context);
        this.worker = new MaxwellPubsubProducerWorker(context, pubsubProjectId, pubsubTopic, ddlPubsubTopic, pubsubMessageOrderingKey, pubsubEmulator, this.queue);
        Thread thread = new Thread((Runnable)this.worker, "maxwell-pubsub-worker");
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void push(RowMap r) throws Exception {
        this.queue.put(r);
    }

    @Override
    public StoppableTask getStoppableTask() {
        return this.worker;
    }
}

