/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.producer;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.AmazonSQSAsyncClientBuilder;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.producer.AbstractAsyncProducer;
import com.zendesk.maxwell.producer.SQSCallback;
import com.zendesk.maxwell.row.RowMap;

public class MaxwellSQSProducer
extends AbstractAsyncProducer {
    private AmazonSQSAsync client;
    private String queueUri;

    public MaxwellSQSProducer(MaxwellContext context, String queueUri, String serviceEndpoint, String signingRegion) {
        super(context);
        this.queueUri = queueUri;
        this.client = (AmazonSQSAsync)((AmazonSQSAsyncClientBuilder)AmazonSQSAsyncClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(serviceEndpoint, signingRegion))).build();
    }

    @Override
    public void sendAsync(RowMap r, AbstractAsyncProducer.CallbackCompleter cc) throws Exception {
        String value = r.toJSON(this.outputConfig);
        SendMessageRequest messageRequest = new SendMessageRequest(this.queueUri, value);
        if (this.queueUri.endsWith(".fifo")) {
            messageRequest.setMessageGroupId(r.getDatabase());
        }
        SQSCallback callback = new SQSCallback(cc, r.getNextPosition(), value, this.context);
        this.client.sendMessageAsync(messageRequest, (AsyncHandler)callback);
    }
}

